/*
 * Decompiled with CFR 0.152.
 */
package org.mule.amf.impl.model;

import amf.client.model.domain.ValidatorAware;
import amf.client.validate.ValidationReport;
import org.mule.amf.impl.model.ParameterValidationStrategy;
import org.mule.apikit.ParserUtils;

abstract class ValidationStrategy
implements ParameterValidationStrategy {
    protected ValidatorAware schema;
    protected final boolean schemaNeedsQuotes;

    protected ValidationStrategy(ValidatorAware schema, boolean schemaNeedsQuotes) {
        this.schema = schema;
        this.schemaNeedsQuotes = schemaNeedsQuotes;
    }

    @Override
    public ValidationReport validatePayload(String value) {
        if (value == null) {
            return this.validate(null);
        }
        if (this.needsPreProcess(value)) {
            return this.validate(this.preProcessValue(value));
        }
        return this.validate(value);
    }

    @Override
    public String preProcessValue(String value) {
        if (value == null) {
            return null;
        }
        if (this.valueNeedQuotes(value)) {
            return ParserUtils.quoteValue((String)this.escapeCharsInValue(value));
        }
        return this.removeLeadingZeros(value);
    }

    abstract boolean valueNeedQuotes(String var1);

    abstract boolean needsPreProcess(String var1);

    abstract ValidationReport validate(String var1);

    abstract String escapeCharsInValue(String var1);

    abstract String removeLeadingZeros(String var1);
}

