/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.cmis;

import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.commons.lang.StringUtils;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.modules.cmis.model.Authentication;
import org.mule.modules.cmis.model.CMISConnectionType;
import org.mule.modules.cmis.runtime.CMISFacade;
import org.mule.modules.cmis.runtime.CMISFacadeAdaptor;
import org.mule.modules.cmis.runtime.ChemistryCMISFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    private final Object threadSafeLock = new Object();
    private CMISFacade facade;
    private String connectionIdentifier;
    private CMISConnectionType endpoint;
    Authentication authentication;
    String cxfPortProvider;
    String connectionTimeout;
    boolean useAlfrescoExtension;
    boolean useCookies;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String baseUrl, String username, String password, String repositoryId) throws ConnectionException {
        if (StringUtils.isBlank((String)username)) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, null, "The \"username\" attribute of the \"config\" element for the repository connector configuration is empty or missing. This configuration is required in order to provide repository connection parameters to the connector. The connector is currently non-functional.");
        }
        if (StringUtils.isBlank((String)password)) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, null, "The \"password\" attribute of the \"config\" element for the repository connector configuration is empty or missing. This configuration is required in order to provide repository connection parameters to the connector. The connector is currently non-functional.");
        }
        if (StringUtils.isBlank((String)baseUrl)) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, null, "The \"baseUrl\" attribute of the \"config\" element for the repository connector configuration is empty or missing. This configuration is required in order to provide repository connection parameters to the connector. The connector is currently non-functional.");
        }
        Object object = this.threadSafeLock;
        synchronized (object) {
            if (this.facade == null) {
                this.setConnectionIdentifier(username + "@" + baseUrl);
                try {
                    this.facade = CMISFacadeAdaptor.adapt(new ChemistryCMISFacade(username, password, baseUrl.trim(), repositoryId, this.getEndpoint(), this.getConnectionTimeout(), this.getCxfPortProvider(), this.getUseAlfrescoExtension(), this.getUseCookies(), this.getAuthentication()));
                }
                catch (Exception e) {
                    if (StringUtils.isEmpty((String)e.getMessage()) || e.getCause() instanceof CmisPermissionDeniedException) {
                        String msg = "Access to the specified resource (Failed to authenticate) has been forbidden. Please verify \"baseUrl\", \"username\", and \"password\" are valid.  The connector is currently non-functional.";
                        logger.error(msg, (Throwable)e);
                        throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, null, msg);
                    }
                    throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, null, e.getMessage());
                }
            }
        }
    }

    public void testConnect(String baseUrl, String username, String password, String repositoryId) throws ConnectionException {
        this.connect(baseUrl, username, password, repositoryId);
        this.facade.repositoryInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.threadSafeLock;
        synchronized (object) {
            this.facade = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.threadSafeLock;
        synchronized (object) {
            return this.facade != null;
        }
    }

    public String getConnectionIdentifier() {
        return this.connectionIdentifier;
    }

    public void setConnectionIdentifier(String connectionIdentifier) {
        this.connectionIdentifier = connectionIdentifier;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getCxfPortProvider() {
        return this.cxfPortProvider;
    }

    public void setCxfPortProvider(String cxfPortProvider) {
        this.cxfPortProvider = cxfPortProvider;
    }

    public CMISConnectionType getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(CMISConnectionType endpoint) {
        this.endpoint = endpoint;
    }

    public Boolean getUseAlfrescoExtension() {
        return this.useAlfrescoExtension;
    }

    public void setUseAlfrescoExtension(Boolean useAlfrescoExtension) {
        this.useAlfrescoExtension = useAlfrescoExtension;
    }

    public Boolean getUseCookies() {
        return this.useCookies;
    }

    public void setUseCookies(Boolean useCookies) {
        this.useCookies = useCookies;
    }

    public CMISFacade getFacade() {
        return this.facade;
    }

    public void setFacade(CMISFacade facade) {
        this.facade = facade;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }
}

