/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.cmis.config;

import org.mule.config.MuleManifest;
import org.mule.modules.cmis.config.ApplyAclDefinitionParser;
import org.mule.modules.cmis.config.ApplyAspectDefinitionParser;
import org.mule.modules.cmis.config.ApplyPolicyDefinitionParser;
import org.mule.modules.cmis.config.CMISConnectorConfigConfigDefinitionParser;
import org.mule.modules.cmis.config.CancelCheckOutDefinitionParser;
import org.mule.modules.cmis.config.ChangelogDefinitionParser;
import org.mule.modules.cmis.config.CheckInDefinitionParser;
import org.mule.modules.cmis.config.CheckOutDefinitionParser;
import org.mule.modules.cmis.config.CreateDocumentByIdDefinitionParser;
import org.mule.modules.cmis.config.CreateDocumentByPathDefinitionParser;
import org.mule.modules.cmis.config.CreateFolderDefinitionParser;
import org.mule.modules.cmis.config.CreateRelationshipDefinitionParser;
import org.mule.modules.cmis.config.DeleteDefinitionParser;
import org.mule.modules.cmis.config.DeleteTreeDefinitionParser;
import org.mule.modules.cmis.config.FolderDefinitionParser;
import org.mule.modules.cmis.config.GetAclDefinitionParser;
import org.mule.modules.cmis.config.GetAllVersionsDefinitionParser;
import org.mule.modules.cmis.config.GetAppliedPoliciesDefinitionParser;
import org.mule.modules.cmis.config.GetCheckoutDocsDefinitionParser;
import org.mule.modules.cmis.config.GetContentStreamDefinitionParser;
import org.mule.modules.cmis.config.GetObjectByIdDefinitionParser;
import org.mule.modules.cmis.config.GetObjectByPathDefinitionParser;
import org.mule.modules.cmis.config.GetObjectRelationshipsDefinitionParser;
import org.mule.modules.cmis.config.GetOrCreateFolderByPathDefinitionParser;
import org.mule.modules.cmis.config.GetParentFoldersDefinitionParser;
import org.mule.modules.cmis.config.GetTypeDefinitionDefinitionParser;
import org.mule.modules.cmis.config.MoveObjectDefinitionParser;
import org.mule.modules.cmis.config.QueryDefinitionParser;
import org.mule.modules.cmis.config.RepositoriesDefinitionParser;
import org.mule.modules.cmis.config.RepositoryInfoDefinitionParser;
import org.mule.modules.cmis.config.UpdateObjectPropertiesDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class CmisNamespaceHandler
extends NamespaceHandlerSupport {
    private static Logger logger = LoggerFactory.getLogger(CmisNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        }
        catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [cmis] is not supported in mule " + muleVersion);
        throw new FatalBeanException("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [cmis] is not supported in mule " + muleVersion, (Throwable)noClassDefFoundError);
    }

    public void init() {
        try {
            this.registerBeanDefinitionParser("config", (BeanDefinitionParser)new CMISConnectorConfigConfigDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("repositories", (BeanDefinitionParser)new RepositoriesDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("repositories", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("repository-info", (BeanDefinitionParser)new RepositoryInfoDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("repository-info", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("changelog", (BeanDefinitionParser)new ChangelogDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("changelog", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-object-by-id", (BeanDefinitionParser)new GetObjectByIdDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("get-object-by-id", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-object-by-path", (BeanDefinitionParser)new GetObjectByPathDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("get-object-by-path", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-document-by-path", (BeanDefinitionParser)new CreateDocumentByPathDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("create-document-by-path", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-or-create-folder-by-path", (BeanDefinitionParser)new GetOrCreateFolderByPathDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("get-or-create-folder-by-path", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-document-by-id", (BeanDefinitionParser)new CreateDocumentByIdDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("create-document-by-id", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-folder", (BeanDefinitionParser)new CreateFolderDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("create-folder", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-type-definition", (BeanDefinitionParser)new GetTypeDefinitionDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("get-type-definition", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-checkout-docs", (BeanDefinitionParser)new GetCheckoutDocsDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("get-checkout-docs", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("query", (BeanDefinitionParser)new QueryDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("query", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-parent-folders", (BeanDefinitionParser)new GetParentFoldersDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("get-parent-folders", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("folder", (BeanDefinitionParser)new FolderDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("folder", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-content-stream", (BeanDefinitionParser)new GetContentStreamDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("get-content-stream", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("move-object", (BeanDefinitionParser)new MoveObjectDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("move-object", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update-object-properties", (BeanDefinitionParser)new UpdateObjectPropertiesDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("update-object-properties", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-object-relationships", (BeanDefinitionParser)new GetObjectRelationshipsDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("get-object-relationships", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-acl", (BeanDefinitionParser)new GetAclDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("get-acl", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-all-versions", (BeanDefinitionParser)new GetAllVersionsDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("get-all-versions", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("check-out", (BeanDefinitionParser)new CheckOutDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("check-out", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("cancel-check-out", (BeanDefinitionParser)new CancelCheckOutDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("cancel-check-out", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("check-in", (BeanDefinitionParser)new CheckInDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("check-in", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("apply-acl", (BeanDefinitionParser)new ApplyAclDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("apply-acl", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("get-applied-policies", (BeanDefinitionParser)new GetAppliedPoliciesDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("get-applied-policies", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("apply-policy", (BeanDefinitionParser)new ApplyPolicyDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("apply-policy", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete", (BeanDefinitionParser)new DeleteDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("delete", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-tree", (BeanDefinitionParser)new DeleteTreeDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("delete-tree", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("apply-aspect", (BeanDefinitionParser)new ApplyAspectDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("apply-aspect", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create-relationship", (BeanDefinitionParser)new CreateRelationshipDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("create-relationship", "@Processor", ex);
        }
    }
}

