/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.cmis.connectivity;

import org.apache.commons.pool.KeyedObjectPool;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.devkit.capability.ModuleCapability;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultTestResult;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.config.PoolingProfile;
import org.mule.devkit.3.7.1.api.lifecycle.LifeCycleManager;
import org.mule.devkit.3.7.1.api.lifecycle.MuleContextAwareManager;
import org.mule.devkit.3.7.1.internal.connection.management.ConnectionManagementConnectionAdapter;
import org.mule.devkit.3.7.1.internal.connection.management.ConnectionManagementConnectionManager;
import org.mule.devkit.3.7.1.internal.connection.management.ConnectionManagementConnectorAdapter;
import org.mule.devkit.3.7.1.internal.connection.management.ConnectionManagementConnectorFactory;
import org.mule.devkit.3.7.1.internal.connection.management.ConnectionManagementProcessTemplate;
import org.mule.devkit.3.7.1.internal.connection.management.UnableToAcquireConnectionException;
import org.mule.devkit.3.7.1.internal.connectivity.ConnectivityTestingErrorHandler;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.modules.cmis.Config;
import org.mule.modules.cmis.adapters.CMISConnectorConnectionManagementAdapter;
import org.mule.modules.cmis.connectivity.ConfigCMISConnectorAdapter;
import org.mule.modules.cmis.connectivity.ConnectionManagementConfigCMISConnectorConnectionKey;
import org.mule.modules.cmis.model.Authentication;
import org.mule.modules.cmis.model.CMISConnectionType;
import org.mule.modules.cmis.pooling.DevkitGenericKeyedObjectPool;

public class CMISConnectorConfigConnectionManagementConnectionManager
extends ExpressionEvaluatorSupport
implements MetadataAware,
MuleContextAware,
ProcessAdapter<CMISConnectorConnectionManagementAdapter>,
Capabilities,
Disposable,
Initialisable,
Testable,
ConnectionManagementConnectionManager<ConnectionManagementConfigCMISConnectorConnectionKey, CMISConnectorConnectionManagementAdapter, Config> {
    private String baseUrl;
    private String username;
    private String password;
    private String repositoryId;
    private CMISConnectionType endpoint;
    private Authentication authentication;
    private String cxfPortProvider;
    private String connectionTimeout;
    private boolean useAlfrescoExtension;
    private boolean useCookies;
    protected MuleContext muleContext;
    private KeyedObjectPool connectionPool;
    protected PoolingProfile poolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "CMIS";
    private static final String MODULE_VERSION = "2.1.0";
    private static final String DEVKIT_VERSION = "3.7.1";
    private static final String DEVKIT_BUILD = "UNNAMED.2613.77421cc";
    private static final String MIN_MULE_VERSION = "3.5.0";

    public void setBaseUrl(String value) {
        this.baseUrl = value;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setUsername(String value) {
        this.username = value;
    }

    public String getUsername() {
        return this.username;
    }

    public void setRepositoryId(String value) {
        this.repositoryId = value;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setEndpoint(CMISConnectionType value) {
        this.endpoint = value;
    }

    public CMISConnectionType getEndpoint() {
        return this.endpoint;
    }

    public void setAuthentication(Authentication value) {
        this.authentication = value;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setCxfPortProvider(String value) {
        this.cxfPortProvider = value;
    }

    public String getCxfPortProvider() {
        return this.cxfPortProvider;
    }

    public void setConnectionTimeout(String value) {
        this.connectionTimeout = value;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setUseAlfrescoExtension(boolean value) {
        this.useAlfrescoExtension = value;
    }

    public boolean getUseAlfrescoExtension() {
        return this.useAlfrescoExtension;
    }

    public void setUseCookies(boolean value) {
        this.useCookies = value;
    }

    public boolean getUseCookies() {
        return this.useCookies;
    }

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setPoolingProfile(PoolingProfile value) {
        this.poolingProfile = value;
    }

    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void initialise() {
        this.connectionPool = new DevkitGenericKeyedObjectPool(new ConnectionManagementConnectorFactory(this), this.poolingProfile);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    public void dispose() {
        try {
            this.connectionPool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public CMISConnectorConnectionManagementAdapter acquireConnection(ConnectionManagementConfigCMISConnectorConnectionKey key) throws Exception {
        return (CMISConnectorConnectionManagementAdapter)this.connectionPool.borrowObject((Object)key);
    }

    @Override
    public void releaseConnection(ConnectionManagementConfigCMISConnectorConnectionKey key, CMISConnectorConnectionManagementAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    @Override
    public void destroyConnection(ConnectionManagementConfigCMISConnectorConnectionKey key, CMISConnectorConnectionManagementAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    public boolean isCapableOf(ModuleCapability capability) {
        if (capability == ModuleCapability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == ModuleCapability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    public <P> ProcessTemplate<P, CMISConnectorConnectionManagementAdapter> getProcessTemplate() {
        return new ConnectionManagementProcessTemplate(this, this.muleContext);
    }

    @Override
    public ConnectionManagementConfigCMISConnectorConnectionKey getDefaultConnectionKey() {
        return new ConnectionManagementConfigCMISConnectorConnectionKey(this.getBaseUrl(), this.getUsername(), this.getPassword(), this.getRepositoryId());
    }

    @Override
    public ConnectionManagementConfigCMISConnectorConnectionKey getEvaluatedConnectionKey(MuleEvent event) throws Exception {
        if (event != null) {
            String _transformedBaseUrl = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("baseUrl").getGenericType(), null, this.getBaseUrl());
            if (_transformedBaseUrl == null) {
                throw new UnableToAcquireConnectionException("Parameter baseUrl in method connect can't be null because is not @Optional");
            }
            String _transformedUsername = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("username").getGenericType(), null, this.getUsername());
            if (_transformedUsername == null) {
                throw new UnableToAcquireConnectionException("Parameter username in method connect can't be null because is not @Optional");
            }
            String _transformedPassword = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("password").getGenericType(), null, this.getPassword());
            if (_transformedPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter password in method connect can't be null because is not @Optional");
            }
            String _transformedRepositoryId = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("repositoryId").getGenericType(), null, this.getRepositoryId());
            return new ConnectionManagementConfigCMISConnectorConnectionKey(_transformedBaseUrl, _transformedUsername, _transformedPassword, _transformedRepositoryId);
        }
        return this.getDefaultConnectionKey();
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    public String getMinMuleVersion() {
        return MIN_MULE_VERSION;
    }

    @Override
    public ConnectionManagementConfigCMISConnectorConnectionKey getConnectionKey(MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        return this.getEvaluatedConnectionKey(event);
    }

    @Override
    public ConnectionManagementConnectionAdapter newConnection() {
        ConfigCMISConnectorAdapter connection = new ConfigCMISConnectorAdapter();
        connection.setEndpoint(this.getEndpoint());
        connection.setAuthentication(this.getAuthentication());
        connection.setCxfPortProvider(this.getCxfPortProvider());
        connection.setConnectionTimeout(this.getConnectionTimeout());
        connection.setUseAlfrescoExtension(this.getUseAlfrescoExtension());
        connection.setUseCookies(this.getUseCookies());
        return connection;
    }

    @Override
    public ConnectionManagementConnectorAdapter newConnector(ConnectionManagementConnectionAdapter<Config, ConnectionManagementConfigCMISConnectorConnectionKey> connection) {
        CMISConnectorConnectionManagementAdapter connector = new CMISConnectorConnectionManagementAdapter();
        connector.setConfig(connection.getStrategy());
        return connector;
    }

    @Override
    public ConnectionManagementConnectionAdapter getConnectionAdapter(ConnectionManagementConnectorAdapter adapter) {
        CMISConnectorConnectionManagementAdapter connector = (CMISConnectorConnectionManagementAdapter)adapter;
        ConnectionManagementConnectionAdapter strategy = (ConnectionManagementConnectionAdapter)((Object)connector.getConfig());
        return strategy;
    }

    public TestResult test() {
        try {
            ConfigCMISConnectorAdapter strategy = (ConfigCMISConnectorAdapter)this.newConnection();
            ConnectionManagementConnectorAdapter connectorAdapter = this.newConnector(strategy);
            MuleContextAwareManager.setMuleContext(connectorAdapter, this.muleContext);
            LifeCycleManager.executeInitialiseAndStart(connectorAdapter);
            strategy.test(this.getDefaultConnectionKey());
            return new DefaultTestResult(Result.Status.SUCCESS);
        }
        catch (Exception e) {
            return (DefaultTestResult)ConnectivityTestingErrorHandler.buildFailureTestResult(e);
        }
    }
}

