/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.cmis.runtime;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.jetbrains.annotations.NotNull;
import org.mule.api.MuleException;
import org.mule.modules.cmis.CMISConnector;
import org.mule.modules.cmis.runtime.ChemistryCMISFacade;
import org.mule.streaming.ProviderAwarePagingDelegate;

public class CMISPagingDelegate
extends ProviderAwarePagingDelegate<QueryResult, CMISConnector> {
    int skipTo = 0;
    private final String query;
    private final String filter;
    private final String orderBy;
    private final Session session;
    private final Integer pageSize;
    private boolean lastPage = false;
    private final boolean allVersions;

    public CMISPagingDelegate(Session session, String query, boolean allVersions, String filter, String orderBy, Integer pageSize) {
        this.session = session;
        this.query = query;
        this.allVersions = allVersions;
        this.filter = filter;
        this.orderBy = orderBy;
        this.pageSize = pageSize;
    }

    public List<QueryResult> getPage(@NotNull CMISConnector connector) throws Exception {
        if (this.session != null && !this.lastPage) {
            OperationContext ctx = ChemistryCMISFacade.createOperationContext(this.filter, this.orderBy);
            ctx.setMaxItemsPerPage(this.pageSize.intValue());
            ItemIterable queryResults = this.session.query(this.query, this.allVersions, ctx);
            ItemIterable page = queryResults.skipTo((long)this.skipTo).getPage();
            ArrayList results = Lists.newArrayList((Iterable)page);
            if (!page.getHasMoreItems()) {
                this.lastPage = true;
            }
            this.skipTo = (int)((long)this.skipTo + page.getPageNumItems());
            return results;
        }
        this.lastPage = false;
        return Collections.emptyList();
    }

    public int getTotalResults(@NotNull CMISConnector connector) throws Exception {
        long size = -1L;
        long skipResultTo = (long)this.pageSize.intValue() * 100L;
        while (this.session != null && !this.lastPage) {
            OperationContext ctx = ChemistryCMISFacade.createOperationContext(this.filter, this.orderBy);
            ItemIterable queryResults = this.session.query(this.query, this.allVersions, ctx);
            ItemIterable page = queryResults.skipTo(skipResultTo).getPage();
            if (!page.getHasMoreItems()) {
                this.lastPage = true;
                size = skipResultTo + page.getTotalNumItems();
            }
            skipResultTo += skipResultTo;
        }
        this.lastPage = false;
        return (int)size;
    }

    public void close() throws MuleException {
        this.skipTo = 0;
        this.lastPage = false;
    }
}

