/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.cmis.runtime;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.cmis.client.AlfrescoDocument;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.ChangeEventsImpl;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.modules.cmis.CMISConnector;
import org.mule.modules.cmis.exception.CMISConnectorConnectionException;
import org.mule.modules.cmis.model.Authentication;
import org.mule.modules.cmis.model.CMISConnectionType;
import org.mule.modules.cmis.model.NavigationOptions;
import org.mule.modules.cmis.runtime.CMISFacade;
import org.mule.modules.cmis.runtime.CMISPagingDelegate;
import org.mule.streaming.PagingConfiguration;
import org.mule.streaming.ProviderAwarePagingDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChemistryCMISFacade
implements CMISFacade {
    private static final Logger logger = LoggerFactory.getLogger(ChemistryCMISFacade.class);
    private Session repositorySession;
    private Map<String, String> connectionParameters;
    private final String baseURL;

    public ChemistryCMISFacade(@NotNull String username, @NotNull String password, @NotNull String baseURL, @Nullable String repositoryId, @NotNull CMISConnectionType endpoint, @Nullable String connectionTimeout, @NotNull String cxfPortProvider, boolean useAlfrescoExtension, boolean useCookies, Authentication authentication) {
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        this.baseURL = baseURL;
        this.connectionParameters = ChemistryCMISFacade.paramMap(username, password, repositoryId, this.baseURL, endpoint, connectionTimeout, useAlfrescoExtension, cxfPortProvider, authentication, useCookies);
    }

    public static ContentStream createContentStream(String filename, String mimeType, Object content) {
        ContentStreamImpl ret;
        if (content instanceof String) {
            ret = new ContentStreamImpl(filename, mimeType, (String)content);
        } else {
            ret = new ContentStreamImpl();
            ret.setFileName(filename);
            ret.setMimeType(mimeType);
            if (content instanceof InputStream) {
                ret.setStream((InputStream)content);
            } else if (content instanceof byte[]) {
                ret.setStream((InputStream)new ByteArrayInputStream((byte[])content));
            } else if (content instanceof Document) {
                ret = (ContentStreamImpl)((Document)content).getContentStream();
            } else {
                throw new IllegalArgumentException("The content must be one of the following: Document, InputStream or Byte array. The received type is not a valid one for generating a content stream: " + content.getClass());
            }
        }
        return ret;
    }

    private static void validateObjectOrId(CmisObject object, String objectId) {
        if (object == null && StringUtils.isBlank((String)objectId)) {
            throw new IllegalArgumentException("Both the cmis object and it's ID are not set, either of them is required.");
        }
    }

    private static void validateRedundantIdentifier(CmisObject object, String objectId) {
        if (object != null && StringUtils.isNotBlank((String)objectId) && !object.getId().equals(objectId)) {
            throw new IllegalArgumentException("The id provided does not match the object's ID");
        }
    }

    protected static OperationContext createOperationContext(String filter, String orderBy) {
        OperationContextImpl ctx = new OperationContextImpl();
        ctx.setIncludeAcls(true);
        ctx.setIncludePolicies(true);
        ctx.setIncludeRelationships(IncludeRelationships.BOTH);
        if (StringUtils.isNotBlank((String)filter) || StringUtils.isNotBlank((String)orderBy)) {
            if (StringUtils.isNotBlank((String)filter)) {
                ctx.setFilterString(filter);
            }
            if (StringUtils.isNotBlank((String)orderBy)) {
                ctx.setOrderBy(orderBy);
            }
        }
        return ctx;
    }

    private static Map<String, String> paramMap(String username, String password, String repositoryId, String baseURL, CMISConnectionType endpoint, String connectionTimeout, boolean useAlfrescoExtension, String cxfPortProvider, Authentication authentication, boolean useCookies) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        switch (authentication) {
            case STANDARD: {
                parameters.put("org.apache.chemistry.opencmis.user", username.trim());
                parameters.put("org.apache.chemistry.opencmis.password", password.trim());
                break;
            }
            case NTLM: {
                parameters.put("org.apache.chemistry.opencmis.user", username.trim());
                parameters.put("org.apache.chemistry.opencmis.password", password.trim());
                parameters.put("org.apache.chemistry.opencmis.binding.auth.classname", "org.apache.chemistry.opencmis.client.bindings.spi.NTLMAuthenticationProvider");
                break;
            }
        }
        parameters.put("org.apache.chemistry.opencmis.binding.cookies", String.valueOf(useCookies));
        if (endpoint.equals((Object)CMISConnectionType.SOAP)) {
            parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", baseURL + "ACLService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", baseURL + "DiscoveryService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", baseURL + "MultiFilingService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", baseURL + "NavigationService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", baseURL + "ObjectService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", baseURL + "PolicyService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", baseURL + "RelationshipService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", baseURL + "RepositoryService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", baseURL + "VersioningService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.portprovider.classname", cxfPortProvider);
        } else {
            parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
            parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", baseURL);
        }
        parameters.put("org.apache.chemistry.opencmis.locale.iso3166", "");
        parameters.put("org.apache.chemistry.opencmis.locale.iso639", "en");
        if (connectionTimeout != null) {
            parameters.put("org.apache.chemistry.opencmis.binding.connecttimeout", connectionTimeout);
        }
        if (StringUtils.isNotEmpty((String)repositoryId)) {
            parameters.put("org.apache.chemistry.opencmis.session.repository.id", repositoryId.trim());
        } else {
            String repoID = ChemistryCMISFacade.getRepositoryID(parameters, baseURL);
            if (StringUtils.isNotEmpty((String)repoID)) {
                parameters.put("org.apache.chemistry.opencmis.session.repository.id", repoID);
            }
        }
        if (useAlfrescoExtension) {
            parameters.put("org.apache.chemistry.opencmis.objectfactory.classname", "org.alfresco.cmis.client.impl.AlfrescoObjectFactoryImpl");
            logger.debug("The Alfresco Object Factor CMIS extension has been included in the session parameters.");
        }
        return parameters;
    }

    public static String getRepositoryID(Map<String, String> parameters, String baseURL) {
        String repoID = null;
        try {
            logger.debug("Attempting to dynamically obtain the repository ID.");
            List repositoryList = SessionFactoryImpl.newInstance().getRepositories(parameters);
            if (repositoryList.isEmpty()) {
                logger.error("No repositories were returned at the CMIS server URL \"" + baseURL + "\". " + "The connector is currently non-functional.");
            } else {
                Repository firstRepo = (Repository)repositoryList.get(0);
                repoID = firstRepo.getId();
                logger.debug("The repository ID that will be used is " + repoID + ".");
            }
        }
        catch (Exception repoIDEx) {
            throw new CMISConnectorConnectionException("An error occurred while attempting to dynamically obtain a repository ID: " + repoIDEx.getMessage() + ". The connector is currently non-functional. ", repoIDEx);
        }
        return repoID;
    }

    @Override
    public List<Repository> repositories() {
        return SessionFactoryImpl.newInstance().getRepositories(this.connectionParameters);
    }

    @Override
    public RepositoryInfo repositoryInfo() {
        RepositoryInfo repoInfo = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            repoInfo = session.getRepositoryInfo();
        }
        return repoInfo;
    }

    @Override
    public ChangeEvents changelog(String changeLogToken, boolean includeProperties) {
        boolean hasMore = false;
        String token = changeLogToken;
        ChangeEventsImpl returnEvents = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            ArrayList changeEvents = new ArrayList();
            long totalNumItems = 0L;
            do {
                String t;
                ChangeEvents events = session.getContentChanges(token, includeProperties, 50L);
                totalNumItems += events.getTotalNumItems();
                changeEvents.addAll(events.getChangeEvents());
                if (!events.getHasMoreItems() || (t = events.getLatestChangeLogToken()) == null || t.equals(token)) continue;
                hasMore = true;
                token = t;
            } while (hasMore);
            returnEvents = new ChangeEventsImpl(token, changeEvents, false, totalNumItems);
        }
        return returnEvents;
    }

    @Override
    public CmisObject getObjectById(String objectId) {
        CmisObject returnObj = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            returnObj = session.getObject(session.createObjectId(objectId), ChemistryCMISFacade.createOperationContext(null, null));
        }
        return returnObj;
    }

    @Override
    public CmisObject getObjectByPath(String path) {
        CmisObject returnObj = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            returnObj = session.getObjectByPath(path, ChemistryCMISFacade.createOperationContext(null, null));
        }
        return returnObj;
    }

    @Override
    public ObjectId createDocumentById(@NotNull(value="No folderId was specified in the request.") String folderId, @NotNull(value="No filename was specified in the request.") String filename, @NotNull(value="No document content was specified in the payload.") Object content, @NotNull(value="No file mime type was specified in the request.") String mimeType, org.mule.modules.cmis.model.VersioningState versioningState, @NotNull(value="No object type was specified in the request.") String objectType, Map<String, Object> properties) {
        ObjectId returnId = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            logger.debug("Preparing to create a document with file name \"" + filename + "\" in the folder with ID \"" + folderId + "\".");
            returnId = this.createDocument(session.getObject(session.createObjectId(folderId)), filename, content, mimeType, versioningState, objectType, properties);
            logger.debug("The ID of the repository node after document creation is \"" + returnId.getId() + "\".");
        }
        return returnId;
    }

    @Override
    public ObjectId createDocumentByPath(@NotNull(value="No folderPath was specified in the request.") String folderPath, @NotNull(value="No filename was specified in the request.") String filename, @NotNull(value="No document content was specified in the payload.") Object content, @NotNull(value="No file mime type was specified in the request.") String mimeType, org.mule.modules.cmis.model.VersioningState versioningState, @NotNull(value="No object type was specified in the request.") String objectType, Map<String, Object> properties, boolean force) {
        ObjectId returnId = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            logger.debug("Preparing to create a document with file name \"" + filename + "\" in folder \"" + folderPath + "\".");
            returnId = this.createDocument(force ? this.getOrCreateFolderByPath(folderPath) : session.getObjectByPath(folderPath), filename, content, mimeType, versioningState, objectType, properties);
            logger.debug("The ID of the repository node after document creation is \"" + returnId.getId() + "\".");
        }
        return returnId;
    }

    @Override
    public CmisObject getOrCreateFolderByPath(@NotNull(value="No folderPath was specified in the request.") String folderPath) {
        CmisObject returnObj = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            try {
                returnObj = session.getObjectByPath(folderPath);
            }
            catch (CmisObjectNotFoundException e) {
                logger.debug("CMIS Object Not Found, Creating a Folder Structure: ", (Throwable)e);
                return this.createFolderStructure(folderPath);
            }
        }
        return returnObj;
    }

    private CmisObject createFolderStructure(String folderPath) {
        String[] folderNames = StringUtils.split((String)folderPath, (String)"/");
        String currentObjectId = this.getObjectByPath("/").getId();
        String currentPath = "/";
        for (String folder : folderNames) {
            currentPath = currentPath + folder + "/";
            CmisObject currentObject = null;
            try {
                currentObject = this.getObjectByPath(currentPath);
            }
            catch (CmisObjectNotFoundException ex) {
                logger.debug("Path not found: " + currentPath, (Throwable)ex);
            }
            currentObjectId = currentObject != null ? currentObject.getId() : this.createFolder(folder, currentObjectId).getId();
        }
        return this.getObjectById(currentObjectId);
    }

    protected ObjectId createDocument(@NotNull(value="No folder was specified in the request.") CmisObject folder, @NotNull(value="No filename was specified in the request.") String filename, @NotNull(value="No document content was specified in the payload.") Object content, @NotNull(value="No file mime type was specified in the request.") String mimeType, @NotNull(value="No versioning state was specified in the request.") org.mule.modules.cmis.model.VersioningState versioningState, String objectType, Map<String, Object> extraProperties) {
        ObjectId returnId = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            VersioningState vs;
            try {
                vs = VersioningState.valueOf((String)versioningState.name());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Illegal value for versioningState. Given `%s' could be: %s", new Object[]{versioningState, Arrays.toString(VersioningState.values())}), e);
            }
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("cmis:objectTypeId", objectType);
            properties.put("cmis:name", filename);
            if (extraProperties != null) {
                properties.putAll(extraProperties);
            }
            returnId = session.createDocument(properties, session.createObjectId(folder.getId()), ChemistryCMISFacade.createContentStream(filename, mimeType, content), vs);
        }
        return returnId;
    }

    @Override
    public ObjectId createFolder(String folderName, String parentObjectId) {
        ObjectId returnId = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            if (StringUtils.isEmpty((String)parentObjectId)) {
                parentObjectId = session.getRootFolder().getId();
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("cmis:name", folderName);
            properties.put("cmis:objectTypeId", "cmis:folder");
            try {
                returnId = session.createFolder(properties, (ObjectId)session.getObject(session.createObjectId(parentObjectId)));
            }
            catch (CmisContentAlreadyExistsException e) {
                logger.debug("CMIS Content Already Exists ", (Throwable)e);
                CmisObject object = session.getObject(session.createObjectId(parentObjectId));
                if (!(object instanceof Folder)) {
                    throw new IllegalArgumentException(parentObjectId + " is not a folder");
                }
                Folder folder = (Folder)object;
                for (CmisObject o : folder.getChildren()) {
                    if (!o.getName().equals(folderName)) continue;
                    return session.createObjectId(o.getId());
                }
            }
        }
        return returnId;
    }

    @Override
    public ObjectType getTypeDefinition(String typeId) {
        ObjectType returnTypeDef = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            Validate.notEmpty((String)typeId, (String)"typeId is empty");
            returnTypeDef = session.getTypeDefinition(typeId);
        }
        return returnTypeDef;
    }

    @Override
    public ItemIterable<Document> getCheckoutDocs(String filter, String orderBy) {
        ItemIterable docList = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            docList = session.getCheckedOutDocs(ChemistryCMISFacade.createOperationContext(filter, orderBy));
        }
        return docList;
    }

    @Override
    public ProviderAwarePagingDelegate<QueryResult, CMISConnector> query(@NotNull String query, @NotNull boolean searchAllVersions, String filter, String orderBy, PagingConfiguration pagingConfiguration) {
        Validate.notEmpty((String)query, (String)"Query is empty");
        logger.debug("Preparing to execute the CMIS query \"" + query + "\".");
        Session session = this.getSession(this.connectionParameters);
        return new CMISPagingDelegate(session, query, searchAllVersions, filter, orderBy, pagingConfiguration.getFetchSize());
    }

    @Override
    public List<Folder> getParentFolders(CmisObject cmisObject, String objectId) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null && target instanceof FileableCmisObject) {
            return ((FileableCmisObject)target).getParents();
        }
        logger.error("Unable to obtain the object reference, so no parent references could be obtained.");
        return Collections.emptyList();
    }

    @Override
    public Object folder(Folder folder, String folderId, NavigationOptions get, Integer depth, String filter, String orderBy) {
        ChemistryCMISFacade.validateObjectOrId((CmisObject)folder, folderId);
        ChemistryCMISFacade.validateRedundantIdentifier((CmisObject)folder, folderId);
        Folder target = this.getCmisObject(folder, folderId, Folder.class);
        Object ret = null;
        if (target != null) {
            if (get.equals((Object)NavigationOptions.DESCENDANTS) || get.equals((Object)NavigationOptions.TREE)) {
                Validate.notNull((Object)depth, (String)"depth is null");
            }
            if (get.equals((Object)NavigationOptions.PARENT)) {
                ret = target.getFolderParent();
            } else {
                OperationContext ctx = ChemistryCMISFacade.createOperationContext(filter, orderBy);
                if (get.equals((Object)NavigationOptions.CHILDREN)) {
                    ret = target.getChildren(ctx);
                } else if (get.equals((Object)NavigationOptions.DESCENDANTS)) {
                    ret = target.getDescendants(depth.intValue(), ctx);
                } else if (get.equals((Object)NavigationOptions.TREE)) {
                    ret = target.getFolderTree(depth.intValue(), ctx);
                }
            }
        }
        return ret;
    }

    @Override
    public ContentStream getContentStream(CmisObject cmisObject, String objectId) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null && target instanceof Document) {
            return ((Document)target).getContentStream();
        }
        logger.error("Unable to obtain the object reference in order to obtain the content of the object.");
        return null;
    }

    @Override
    public FileableCmisObject moveObject(FileableCmisObject cmisObject, String objectId, String sourceFolderId, String targetFolderId) {
        ChemistryCMISFacade.validateObjectOrId((CmisObject)cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier((CmisObject)cmisObject, objectId);
        Validate.notEmpty((String)sourceFolderId, (String)"sourceFolderId is empty");
        Validate.notEmpty((String)targetFolderId, (String)"targetFolderId is empty");
        FileableCmisObject target = this.getCmisObject(cmisObject, objectId, FileableCmisObject.class);
        if (target != null) {
            return target.move((ObjectId)new ObjectIdImpl(sourceFolderId), (ObjectId)new ObjectIdImpl(targetFolderId));
        }
        logger.error("Unable to obtain the object reference in order to perform the object move.");
        return null;
    }

    @Override
    public CmisObject updateObjectProperties(CmisObject cmisObject, String objectId, Map<String, Object> properties) {
        CmisObject returnObj = null;
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        Validate.notNull(properties, (String)"properties is null");
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            returnObj = target.updateProperties(properties);
        } else {
            logger.error("Unable to obtain the object reference in order to update the properties of the object.");
        }
        return returnObj;
    }

    @Override
    public void delete(CmisObject cmisObject, String objectId, boolean allVersions) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            target.delete(allVersions);
        }
    }

    @Override
    public List<String> deleteTree(@Nullable CmisObject folder, @Nullable String folderId, UnfileObject unfile, boolean allversions, boolean continueOnFailure) {
        ChemistryCMISFacade.validateObjectOrId(folder, folderId);
        ChemistryCMISFacade.validateRedundantIdentifier(folder, folderId);
        CmisObject target = this.getCmisObject(folder, folderId);
        if (target != null && target instanceof Folder) {
            return ((Folder)target).deleteTree(allversions, unfile, continueOnFailure);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Relationship> getObjectRelationships(CmisObject cmisObject, String objectId) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            return target.getRelationships();
        }
        return Collections.emptyList();
    }

    @Override
    public Acl getAcl(CmisObject cmisObject, String objectId) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            return target.getAcl();
        }
        return null;
    }

    @Override
    public List<Document> getAllVersions(CmisObject document, String documentId, String filter, String orderBy) {
        ChemistryCMISFacade.validateObjectOrId(document, documentId);
        ChemistryCMISFacade.validateRedundantIdentifier(document, documentId);
        CmisObject target = this.getCmisObject(document, documentId);
        if (target instanceof Document) {
            OperationContext ctx = ChemistryCMISFacade.createOperationContext(filter, orderBy);
            return ((Document)target).getAllVersions(ctx);
        }
        return Collections.emptyList();
    }

    @Override
    public ObjectId checkOut(CmisObject document, String documentId) {
        ChemistryCMISFacade.validateObjectOrId(document, documentId);
        ChemistryCMISFacade.validateRedundantIdentifier(document, documentId);
        CmisObject target = this.getCmisObject(document, documentId);
        if (target != null && target instanceof Document) {
            return ((Document)target).checkOut();
        }
        return null;
    }

    @Override
    public void cancelCheckOut(CmisObject document, String documentId) {
        ChemistryCMISFacade.validateObjectOrId(document, documentId);
        ChemistryCMISFacade.validateRedundantIdentifier(document, documentId);
        CmisObject target = this.getCmisObject(document, documentId);
        if (target != null && target instanceof Document) {
            ((Document)target).cancelCheckOut();
        }
    }

    @Override
    public ObjectId checkIn(CmisObject document, String documentId, Object content, String filename, String mimeType, boolean major, String checkinComment, Map<String, Object> properties) {
        ChemistryCMISFacade.validateObjectOrId(document, documentId);
        ChemistryCMISFacade.validateRedundantIdentifier(document, documentId);
        Validate.notEmpty((String)filename, (String)"filename is empty");
        Validate.notNull((Object)content, (String)"content is null");
        Validate.notEmpty((String)mimeType, (String)"did you mean application/octet-stream?");
        Validate.notEmpty((String)checkinComment, (String)"checkinComment is empty");
        CmisObject target = this.getCmisObject(document, documentId);
        if (target != null && target instanceof Document) {
            Document doc = (Document)target;
            return doc.checkIn(major, this.coalesceProperties(properties), ChemistryCMISFacade.createContentStream(filename, mimeType, content), checkinComment);
        }
        return null;
    }

    private Map<String, Object> coalesceProperties(Map<String, Object> properties) {
        return properties != null ? properties : Collections.emptyMap();
    }

    @Override
    public Acl applyAcl(CmisObject cmisObject, String objectId, List<Ace> addAces, List<Ace> removeAces, AclPropagation aclPropagation) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            return target.applyAcl(addAces, removeAces, aclPropagation);
        }
        return null;
    }

    @Override
    public List<Policy> getAppliedPolicies(CmisObject cmisObject, String objectId) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            return target.getPolicies();
        }
        return Collections.emptyList();
    }

    @Override
    public void applyPolicy(CmisObject cmisObject, String objectId, List<ObjectId> policyIds) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        Validate.notNull(policyIds);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            target.applyPolicy(policyIds.toArray(new ObjectId[policyIds.size()]));
        }
    }

    @Override
    public void applyAspect(String objectId, String aspectName, Map<String, Object> properties) {
        ChemistryCMISFacade.validateObjectOrId(null, objectId);
        CmisObject target = this.getCmisObject(null, objectId);
        AlfrescoDocument alfDocument = (AlfrescoDocument)target;
        if (alfDocument != null && !alfDocument.hasAspect("P:" + aspectName)) {
            alfDocument.addAspect(new String[]{"P:" + aspectName});
            if (properties != null) {
                alfDocument.updateProperties(properties);
            }
        }
    }

    @Override
    public ObjectId createRelationship(String parentObjectId, String childObjectId, String relationshipType) {
        if (StringUtils.isEmpty((String)parentObjectId)) {
            logger.error("No value was specified for the required attribute \"parentObjectId\". No relationship could be created.");
            return null;
        }
        if (StringUtils.isEmpty((String)childObjectId)) {
            logger.error("No value was specified for the required attribute \"childObjectId\". No relationship could be created.");
            return null;
        }
        if (StringUtils.isEmpty((String)relationshipType)) {
            logger.error("No value was specified for the required attribute \"relationshipType\". No relationship could be created.");
            return null;
        }
        Session session = this.getSession(this.connectionParameters);
        if (session == null) {
            logger.error("Unable to obtain a repository session, so no relationship could be created.");
            return null;
        }
        try {
            CmisObject parentObj = this.getObjectById(parentObjectId);
            if (parentObj == null) {
                logger.error("The parent object with ID \"" + parentObjectId + "\" doesn't exists in the repository. No relationship will be created.");
                return null;
            }
        }
        catch (Exception objEx) {
            logger.error("An error occurred while attempting to determine if an the parent object with ID \"" + parentObjectId + "\" exists in the repository. ", (Throwable)objEx);
            return null;
        }
        try {
            CmisObject childObj = this.getObjectById(childObjectId);
            if (childObj == null) {
                logger.error("The child object with ID \"" + childObjectId + "\" doesn't exists in the repository. No relationship will be created.");
                return null;
            }
        }
        catch (Exception objEx) {
            logger.error("An error occurred while attempting to determine if an the child object with ID \"" + childObjectId + "\" exists in the repository. ", (Throwable)objEx);
            return null;
        }
        HashMap<String, String> relProps = new HashMap<String, String>();
        relProps.put("cmis:sourceId", parentObjectId);
        relProps.put("cmis:targetId", childObjectId);
        relProps.put("cmis:objectTypeId", "R:" + relationshipType);
        try {
            return session.createRelationship(relProps, null, null, null);
        }
        catch (Exception relEx) {
            logger.error("An error occurred while attempting to create a relationship between the parent object with ID \"" + parentObjectId + "\" and the child object with ID \"" + childObjectId + "\". ", (Throwable)relEx);
            return null;
        }
    }

    private CmisObject getCmisObject(CmisObject object, String objectId) {
        return this.getCmisObject(object, objectId, CmisObject.class);
    }

    private <T> T getCmisObject(T object, String objectId, Class<T> clazz) {
        if (object != null) {
            return object;
        }
        CmisObject obj = this.getObjectById(objectId);
        if (obj != null && clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        return null;
    }

    protected Session getSession(Map<String, String> parameters) {
        Session repoSession = this.repositorySession;
        if (parameters == null) {
            throw new CMISConnectorConnectionException("Repository sessions cannot be obtained through the connector because the connector configuration is missing or incorrectly specified in the mule application configuration file.");
        }
        if (StringUtils.isEmpty((String)parameters.get("org.apache.chemistry.opencmis.session.repository.id"))) {
            String repoID = ChemistryCMISFacade.getRepositoryID(parameters, this.baseURL);
            if (repoID == null) {
                throw new CMISConnectorConnectionException("Repository sessions cannot be obtained through the connector because the repository ID is missing from the connector configuration.");
            }
            parameters.put("org.apache.chemistry.opencmis.session.repository.id", repoID);
            return null;
        }
        if (repoSession == null) {
            Validate.notNull(parameters);
            try {
                repoSession = SessionFactoryImpl.newInstance().createSession(parameters);
                repoSession.getDefaultContext().setCacheEnabled(false);
                this.repositorySession = repoSession;
            }
            catch (Exception sessionEx) {
                throw new CMISConnectorConnectionException("An error occurred while attempting to obtain a new repository session - " + sessionEx.getMessage(), sessionEx);
            }
        }
        return repoSession;
    }

    public Map<String, String> getConnectionParameters() {
        return this.connectionParameters;
    }
}

