/*
 * Decompiled with CFR 0.152.
 */
package org.mule.session;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.transport.SessionHandler;
import org.mule.session.DefaultMuleSession;
import org.mule.util.SerializationUtils;

public class SerializeOnlySessionHandler
implements SessionHandler {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    @Override
    public MuleSession retrieveSessionInfoFromMessage(MuleMessage message) throws MuleException {
        MuleSession session = null;
        byte[] serializedSession = (byte[])message.getInboundProperty("MULE_SESSION");
        if (serializedSession != null) {
            session = (MuleSession)SerializationUtils.deserialize(serializedSession, message.getMuleContext());
        }
        return session;
    }

    @Override
    public void retrieveSessionInfoFromMessage(MuleMessage message, MuleSession session) throws MuleException {
        session = this.retrieveSessionInfoFromMessage(message);
    }

    @Override
    public void storeSessionInfoToMessage(MuleSession session, MuleMessage message) throws MuleException {
        byte[] serializedSession = SerializationUtils.serialize((Serializable)this.removeNonSerializableProperties(session, message.getMuleContext()));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding serialized Session header to message: " + serializedSession));
        }
        message.setOutboundProperty("MULE_SESSION", serializedSession);
    }

    protected MuleSession removeNonSerializableProperties(MuleSession session, MuleContext muleContext) {
        DefaultMuleSession copy = new DefaultMuleSession(session);
        copy.removeNonSerializableProperties();
        return copy;
    }

    @Override
    public String getSessionIDKey() {
        return "ID";
    }
}

