/*
 * Decompiled with CFR 0.152.
 */
package org.mule.streaming;

import java.io.Serializable;
import org.mule.api.MuleException;
import org.mule.streaming.Producer;
import org.mule.util.queue.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueProducer<T>
implements Producer<T> {
    private static final Logger logger = LoggerFactory.getLogger(QueueProducer.class);
    private static final long DEFAULT_TIMEOUT_VALUE = 5000L;
    private Queue queue;
    private int size;
    private long timeout;

    public QueueProducer(Queue queue) {
        this(queue, 5000L);
    }

    public QueueProducer(Queue queue, long timeout) {
        if (queue == null) {
            throw new IllegalArgumentException("Cannot make a producer out of a null queue");
        }
        this.queue = queue;
        this.size = queue.size();
        this.timeout = timeout;
    }

    @Override
    public T produce() {
        if (this.queue == null) {
            return null;
        }
        Serializable item = null;
        try {
            item = this.queue.poll(this.timeout);
        }
        catch (InterruptedException e) {
            logger.warn("Thread interrupted while polling in producer. Will return an empty list", (Throwable)e);
        }
        return (T)item;
    }

    @Override
    public void close() throws MuleException {
        this.queue = null;
    }

    @Override
    public int size() {
        return this.size;
    }
}

