/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.api.artifact;

import org.mule.runtime.api.util.MuleSystemProperties;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfigurationLoader;
import org.mule.runtime.module.service.api.artifact.ServiceClassLoaderFactory;
import org.mule.runtime.module.service.api.artifact.ServiceModuleLayerFactory;
import org.mule.runtime.module.service.internal.artifact.LibFolderClassLoaderConfigurationLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ServiceClassLoaderFactoryProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceClassLoaderFactoryProvider.class);
    private static boolean withinModularizedContainer = ServiceClassLoaderFactoryProvider.class.getModule().isNamed();

    public static ClassLoaderConfigurationLoader serviceClassLoaderConfigurationLoader() {
        return new LibFolderClassLoaderConfigurationLoader();
    }

    public static ServiceClassLoaderFactory serviceClassLoaderFactory() {
        if (MuleSystemProperties.classloaderContainerJpmsModuleLayer() && withinModularizedContainer) {
            LOGGER.debug("MRJAR 'ServiceClassLoaderFactoryProvider' implementation, using 'ServiceModuleLayerFactory'...");
            ServiceModuleLayerFactory serviceModuleLayerFactory = new ServiceModuleLayerFactory();
            serviceModuleLayerFactory.setParentLayerFrom(ServiceClassLoaderFactoryProvider.class);
            return serviceModuleLayerFactory;
        }
        LOGGER.debug("MRJAR 'ServiceClassLoaderFactoryProvider' implementation, using 'ServiceClassLoaderFactory'...");
        return new ServiceClassLoaderFactory();
    }

    public static void setWithinModularizedContainer(boolean withinModularizedContainer) {
        ServiceClassLoaderFactoryProvider.withinModularizedContainer = withinModularizedContainer;
    }
}

