/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.ReceiveException;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.transport.http.transformers.HttpClientMethodResponseToObject;

public class HttpClientMessageRequester
extends AbstractMessageRequester {
    protected final HttpConnector connector;
    protected volatile HttpClient client = null;
    protected final Transformer receiveTransformer;

    public HttpClientMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (HttpConnector)endpoint.getConnector();
        this.receiveTransformer = new HttpClientMethodResponseToObject();
        this.receiveTransformer.setMuleContext(this.getEndpoint().getMuleContext());
    }

    protected void doConnect() throws Exception {
        if (this.client == null) {
            this.client = this.connector.doClientConnect();
        }
    }

    protected void doDisconnect() throws Exception {
        this.client = null;
    }

    protected MuleMessage doRequest(long timeout) throws Exception {
        GetMethod httpMethod = new GetMethod(this.endpoint.getEndpointURI().getAddress());
        this.connector.setupClientAuthorization(null, (HttpMethod)httpMethod, this.client, this.endpoint);
        boolean releaseConn = false;
        try {
            HttpClient client = new HttpClient();
            client.executeMethod((HttpMethod)httpMethod);
            if (httpMethod.getStatusCode() == 200) {
                MuleMessage res = (MuleMessage)this.receiveTransformer.transform((Object)httpMethod);
                if ("".equals(res.getPayload())) {
                    releaseConn = true;
                }
                MuleMessage muleMessage = res;
                return muleMessage;
            }
            try {
                releaseConn = true;
                throw new ReceiveException(HttpMessages.requestFailedWithStatus(httpMethod.getStatusLine().toString()), this.endpoint, timeout);
            }
            catch (ReceiveException e) {
                releaseConn = true;
                throw e;
            }
            catch (Exception e) {
                releaseConn = true;
                throw new ReceiveException(this.endpoint, timeout, (Throwable)e);
            }
        }
        finally {
            if (releaseConn) {
                httpMethod.releaseConnection();
            }
        }
    }

    protected void doDispose() {
    }
}

