/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleRuntimeException;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.EndpointURI;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpRequestDispatcher;

class HttpConnectionManager {
    private static final int LAST_CONNECTION = 1;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final HttpConnector connector;
    private final Map<String, HttpRequestDispatcher> socketDispatchers = new HashMap<String, HttpRequestDispatcher>();
    private final Map<String, Integer> socketDispatcherCount = new HashMap<String, Integer>();
    private final WorkManager workManager;

    public HttpConnectionManager(HttpConnector connector, WorkManager workManager) {
        if (connector == null) {
            throw new IllegalArgumentException("HttpConnector can not be null");
        }
        if (workManager == null) {
            throw new IllegalArgumentException("WorkManager can not be null");
        }
        this.connector = connector;
        this.workManager = workManager;
    }

    synchronized void addConnection(EndpointURI endpointURI) {
        try {
            String endpointKey = this.getKeyForEndpointUri(endpointURI);
            if (this.socketDispatchers.containsKey(endpointKey)) {
                this.socketDispatcherCount.put(endpointKey, this.socketDispatcherCount.get(endpointKey) + 1);
            } else {
                ServerSocket serverSocket = this.connector.getServerSocket(endpointURI.getUri());
                HttpRequestDispatcher httpRequestDispatcher = new HttpRequestDispatcher(this.connector, this.connector.getRetryPolicyTemplate(), serverSocket, this.workManager);
                this.socketDispatchers.put(endpointKey, httpRequestDispatcher);
                this.socketDispatcherCount.put(endpointKey, new Integer(1));
                this.workManager.scheduleWork((Work)httpRequestDispatcher, Long.MAX_VALUE, null, (WorkListener)this.connector);
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    synchronized void removeConnection(EndpointURI endpointURI) {
        String endpointKey = this.getKeyForEndpointUri(endpointURI);
        if (!this.socketDispatchers.containsKey(endpointKey)) {
            this.logger.warn((Object)("Trying to disconnect endpoint with uri " + endpointKey + " but " + HttpRequestDispatcher.class.getName() + " does not exists for that uri"));
            return;
        }
        Integer connectionsRequested = this.socketDispatcherCount.get(endpointKey);
        if (connectionsRequested == 1) {
            HttpRequestDispatcher httpRequestDispatcher = this.socketDispatchers.get(endpointKey);
            httpRequestDispatcher.disconnect();
            this.socketDispatchers.remove(endpointKey);
            this.socketDispatcherCount.remove(endpointKey);
        } else {
            this.socketDispatcherCount.put(endpointKey, this.socketDispatcherCount.get(endpointKey) - 1);
        }
    }

    private String getKeyForEndpointUri(EndpointURI endpointURI) {
        return endpointURI.getHost() + ":" + endpointURI.getPort();
    }

    public void dispose() {
        for (HttpRequestDispatcher httpRequestDispatcher : this.socketDispatchers.values()) {
            httpRequestDispatcher.disconnect();
        }
        this.socketDispatchers.clear();
        this.socketDispatcherCount.clear();
        this.workManager.dispose();
    }
}

