/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.resource.spi.work.Work;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpVersion;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.execution.ExecutionTemplate;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.PropertyScope;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;
import org.mule.transport.ConnectException;
import org.mule.transport.NullPayload;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpMuleMessageFactory;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.HttpResponse;
import org.mule.transport.http.HttpServerConnection;
import org.mule.transport.http.RequestLine;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.transport.tcp.TcpConnector;
import org.mule.transport.tcp.TcpMessageReceiver;
import org.mule.util.MapUtils;
import org.mule.util.monitor.Expirable;

public class OldHttpMessageReceiver
extends TcpMessageReceiver {
    public OldHttpMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
    }

    protected Work createWork(Socket socket) throws IOException {
        return new HttpWorker(socket);
    }

    protected void doConnect() throws ConnectException {
        if (this.shouldConnect()) {
            super.doConnect();
        }
    }

    protected boolean shouldConnect() {
        MessageReceiver[] receivers;
        StringBuilder requestUri = new StringBuilder(80);
        requestUri.append(this.endpoint.getProtocol()).append("://");
        requestUri.append(this.endpoint.getEndpointURI().getHost());
        requestUri.append(':').append(this.endpoint.getEndpointURI().getPort());
        requestUri.append('*');
        for (MessageReceiver receiver : receivers = this.connector.getReceivers(requestUri.toString())) {
            if (!receiver.isConnected()) continue;
            return false;
        }
        return true;
    }

    protected String processRelativePath(String contextPath, String path) {
        String relativePath = path.substring(contextPath.length());
        if (relativePath.startsWith("/")) {
            return relativePath.substring(1);
        }
        return relativePath;
    }

    protected MessageReceiver getTargetReceiver(MuleMessage message, ImmutableEndpoint ep) throws ConnectException {
        MessageReceiver receiver;
        String path = (String)message.getInboundProperty("http.request");
        int i = path.indexOf(63);
        if (i > -1) {
            path = path.substring(0, i);
        }
        StringBuilder requestUri = new StringBuilder(80);
        if (path.indexOf("://") == -1) {
            requestUri.append(ep.getProtocol()).append("://");
            requestUri.append(ep.getEndpointURI().getHost());
            requestUri.append(':').append(ep.getEndpointURI().getPort());
            if (!"/".equals(path)) {
                requestUri.append(path);
            }
        }
        String uriStr = requestUri.toString();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Looking up receiver on connector: " + this.connector.getName() + " with URI key: " + requestUri.toString()));
        }
        if ((receiver = this.connector.lookupReceiver(uriStr)) == null && !"/".equals(path)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Secondary lookup of receiver on connector: " + this.connector.getName() + " with URI key: " + requestUri.toString()));
            }
            if ((receiver = OldHttpMessageReceiver.findReceiverByStem(this.connector.getReceivers(), uriStr)) == null && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("No receiver found with secondary lookup on connector: " + this.connector.getName() + " with URI key: " + requestUri.toString()));
                this.logger.warn((Object)("Receivers on connector are: " + MapUtils.toString((Map)this.connector.getReceivers(), (boolean)true)));
            }
        }
        return receiver;
    }

    protected HttpResponse transformResponse(Object response, MuleEvent event) throws MuleException {
        Object message = response instanceof MuleMessage ? (MuleMessage)response : new DefaultMuleMessage(response, this.getEndpoint().getMuleContext());
        message.applyTransformers(null, this.defaultResponseTransformers, HttpResponse.class);
        return (HttpResponse)message.getPayload();
    }

    public static MessageReceiver findReceiverByStem(Map<Object, MessageReceiver> receivers, String uriStr) {
        int match = 0;
        MessageReceiver receiver = null;
        for (Map.Entry<Object, MessageReceiver> e : receivers.entrySet()) {
            String key = (String)e.getKey();
            MessageReceiver candidate = e.getValue();
            if (!uriStr.startsWith(key) || match >= key.length()) continue;
            match = key.length();
            receiver = candidate;
        }
        return receiver;
    }

    protected void initializeMessageFactory() throws InitialisationException {
        try {
            HttpMuleMessageFactory factory = (HttpMuleMessageFactory)super.createMuleMessageFactory();
            boolean enableCookies = MapUtils.getBooleanValue((Map)this.endpoint.getProperties(), (Object)"enableCookies", (boolean)((HttpConnector)this.connector).isEnableCookies());
            factory.setEnableCookies(enableCookies);
            String cookieSpec = MapUtils.getString((Map)this.endpoint.getProperties(), (Object)"cookieSpec", (String)((HttpConnector)this.connector).getCookieSpec());
            factory.setCookieSpec(cookieSpec);
            factory.setExchangePattern(this.endpoint.getExchangePattern());
            this.muleMessageFactory = factory;
        }
        catch (CreateException ce) {
            Message message = MessageFactory.createStaticMessage((String)ce.getMessage());
            throw new InitialisationException(message, (Throwable)ce, (Initialisable)this);
        }
    }

    protected MuleMessage handleUnacceptedFilter(MuleMessage message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message request '" + message.getInboundProperty("http.request") + "' is being rejected since it does not match the filter on this endpoint: " + this.endpoint));
        }
        message.setOutboundProperty("http.status", (Object)String.valueOf(406));
        return message;
    }

    protected class HttpWorker
    implements Work,
    Expirable {
        private HttpServerConnection conn;
        private String remoteClientAddress;

        public HttpWorker(Socket socket) throws IOException {
            String encoding = OldHttpMessageReceiver.this.endpoint.getEncoding();
            if (encoding == null) {
                encoding = OldHttpMessageReceiver.this.getEndpoint().getMuleContext().getConfiguration().getDefaultEncoding();
            }
            this.conn = new HttpServerConnection(socket, encoding, (HttpConnector)OldHttpMessageReceiver.this.connector);
            SocketAddress clientAddress = socket.getRemoteSocketAddress();
            if (clientAddress != null) {
                this.remoteClientAddress = clientAddress.toString();
            }
        }

        public void expired() {
            if (this.conn.isOpen()) {
                this.conn.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long keepAliveTimeout = ((TcpConnector)OldHttpMessageReceiver.this.connector).getKeepAliveTimeout();
            try {
                do {
                    HttpRequest request;
                    this.conn.setKeepAlive(false);
                    if (keepAliveTimeout > 0L) {
                        ((HttpConnector)OldHttpMessageReceiver.this.connector).getKeepAliveMonitor().addExpirable(keepAliveTimeout, TimeUnit.MILLISECONDS, (Expirable)this);
                    }
                    if ((request = this.conn.readRequest()) == null) {
                        break;
                    }
                    try {
                        HttpResponse httpResponse = this.processRequest(request);
                        this.conn.writeResponse(httpResponse);
                    }
                    catch (Exception e) {
                        MuleEvent response = null;
                        if (e instanceof MessagingException) {
                            response = ((MessagingException)e).getEvent();
                        } else {
                            OldHttpMessageReceiver.this.getEndpoint().getMuleContext().getExceptionListener().handleException(e);
                        }
                        if (response != null && response.getMessage().getExceptionPayload() != null && response.getMessage().getExceptionPayload().getException() instanceof MessagingException) {
                            e = (Exception)response.getMessage().getExceptionPayload().getException();
                        }
                        String temp = ExceptionHelper.getErrorMapping((String)OldHttpMessageReceiver.this.connector.getProtocol(), e.getClass(), (MuleContext)OldHttpMessageReceiver.this.flowConstruct.getMuleContext());
                        int httpStatus = Integer.valueOf(temp);
                        if (e instanceof MessagingException) {
                            MuleEvent event = ((MessagingException)e).getEvent();
                            httpStatus = event.getMessage().getOutboundProperty("http.status") != null ? Integer.valueOf(event.getMessage().getOutboundProperty("http.status").toString()) : httpStatus;
                            this.conn.writeResponse(this.buildFailureResponse(event, e.getMessage(), httpStatus));
                        } else {
                            this.conn.writeResponse(this.buildFailureResponse(request.getRequestLine().getHttpVersion(), httpStatus, e.getMessage()));
                        }
                        break;
                    }
                    finally {
                        ((HttpConnector)OldHttpMessageReceiver.this.connector).getKeepAliveMonitor().removeExpirable((Expirable)this);
                        this.conn.reset();
                        if (request.getBody() != null) {
                            request.getBody().close();
                        }
                    }
                } while (this.conn.isKeepAlive());
            }
            catch (Exception e) {
                OldHttpMessageReceiver.this.getEndpoint().getMuleContext().getExceptionListener().handleException(e);
            }
            finally {
                OldHttpMessageReceiver.this.logger.debug((Object)"Closing HTTP connection.");
                if (this.conn.isOpen()) {
                    this.conn.close();
                    this.conn = null;
                }
            }
        }

        protected HttpResponse processRequest(HttpRequest request) throws MuleException, IOException {
            RequestLine requestLine = request.getRequestLine();
            String method = requestLine.getMethod();
            if (method.equals("GET") || method.equals("HEAD") || method.equals("POST") || method.equals("OPTIONS") || method.equals("PUT") || method.equals("DELETE") || method.equals("TRACE") || method.equals("CONNECT") || method.equals("PATCH")) {
                return this.doRequest(request);
            }
            return this.doBad(requestLine);
        }

        protected HttpResponse doRequest(HttpRequest request) throws IOException, MuleException {
            HttpResponse response;
            MessageReceiver receiver;
            this.sendExpect100(request);
            final MuleMessage message = OldHttpMessageReceiver.this.createMuleMessage(request);
            String path = (String)message.getInboundProperty("http.request");
            int i = path.indexOf(63);
            if (i > -1) {
                path = path.substring(0, i);
            }
            message.setProperty("http.request.path", (Object)path, PropertyScope.INBOUND);
            if (OldHttpMessageReceiver.this.logger.isDebugEnabled()) {
                OldHttpMessageReceiver.this.logger.debug(message.getInboundProperty("http.request"));
            }
            if ((receiver = OldHttpMessageReceiver.this.getTargetReceiver(message, OldHttpMessageReceiver.this.endpoint)) != null) {
                MuleEvent returnEvent;
                String contextPath = HttpConnector.normalizeUrl(receiver.getEndpointURI().getPath());
                message.setProperty("http.context.path", (Object)contextPath, PropertyScope.INBOUND);
                message.setProperty("http.context.uri", (Object)receiver.getEndpointURI().getAddress(), PropertyScope.INBOUND);
                message.setProperty("http.relative.path", (Object)OldHttpMessageReceiver.this.processRelativePath(contextPath, path), PropertyScope.INBOUND);
                ExecutionTemplate executionTemplate = OldHttpMessageReceiver.this.createExecutionTemplate();
                try {
                    returnEvent = (MuleEvent)executionTemplate.execute((ExecutionCallback)new ExecutionCallback<MuleEvent>(){

                        public MuleEvent process() throws Exception {
                            HttpWorker.this.preRouteMessage(message);
                            return receiver.routeMessage(message);
                        }
                    });
                }
                catch (MuleException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DefaultMuleException((Throwable)e);
                }
                MuleMessage returnMessage = returnEvent == null ? null : returnEvent.getMessage();
                Object tempResponse = returnMessage != null ? returnMessage.getPayload() : NullPayload.getInstance();
                response = tempResponse instanceof HttpResponse ? (HttpResponse)tempResponse : OldHttpMessageReceiver.this.transformResponse(returnMessage, returnEvent);
                response.setupKeepAliveFromRequestVersion(request.getRequestLine().getHttpVersion());
                HttpConnector httpConnector = (HttpConnector)OldHttpMessageReceiver.this.connector;
                response.disableKeepAlive(!httpConnector.isKeepAlive());
                Header connectionHeader = request.getFirstHeader("Connection");
                if (connectionHeader != null) {
                    String value = connectionHeader.getValue();
                    boolean endpointOverride = this.getEndpointKeepAliveValue(OldHttpMessageReceiver.this.endpoint);
                    if ("keep-alive".equalsIgnoreCase(value) && endpointOverride) {
                        response.setKeepAlive(true);
                        if (response.getHttpVersion().equals(HttpVersion.HTTP_1_0)) {
                            connectionHeader = new Header("Connection", "Keep-Alive");
                            response.setHeader(connectionHeader);
                        }
                    } else if ("close".equalsIgnoreCase(value)) {
                        response.setKeepAlive(false);
                    }
                }
            } else {
                EndpointURI uri = OldHttpMessageReceiver.this.endpoint.getEndpointURI();
                String failedPath = String.format("%s://%s:%d%s", uri.getScheme(), uri.getHost(), uri.getPort(), message.getInboundProperty("http.request.path"));
                response = this.buildFailureResponse(request.getRequestLine().getHttpVersion(), 404, HttpMessages.cannotBindToAddress(failedPath).toString());
            }
            return response;
        }

        private boolean getEndpointKeepAliveValue(ImmutableEndpoint ep) {
            String value = (String)ep.getProperty((Object)"keepAlive");
            if (value != null) {
                return Boolean.parseBoolean(value);
            }
            return true;
        }

        protected HttpResponse doOtherValid(RequestLine requestLine, String method) throws MuleException {
            MuleMessage message = OldHttpMessageReceiver.this.createMuleMessage(null);
            DefaultMuleEvent event = new DefaultMuleEvent(message, (InboundEndpoint)OldHttpMessageReceiver.this.endpoint, OldHttpMessageReceiver.this.flowConstruct);
            OptimizedRequestContext.unsafeSetEvent((MuleEvent)event);
            HttpResponse response = new HttpResponse();
            response.setStatusLine(requestLine.getHttpVersion(), 405);
            response.setBody(HttpMessages.methodNotAllowed(method).toString() + "\r\n");
            return OldHttpMessageReceiver.this.transformResponse(response, (MuleEvent)event);
        }

        protected HttpResponse doBad(RequestLine requestLine) throws MuleException {
            MuleMessage message = OldHttpMessageReceiver.this.createMuleMessage(null);
            DefaultMuleEvent event = new DefaultMuleEvent(message, (InboundEndpoint)OldHttpMessageReceiver.this.endpoint, OldHttpMessageReceiver.this.flowConstruct);
            OptimizedRequestContext.unsafeSetEvent((MuleEvent)event);
            HttpResponse response = new HttpResponse();
            response.setStatusLine(requestLine.getHttpVersion(), 400);
            response.setBody(HttpMessages.malformedSyntax().toString() + "\r\n");
            return OldHttpMessageReceiver.this.transformResponse(response, (MuleEvent)event);
        }

        private void sendExpect100(HttpRequest request) throws MuleException, IOException {
            String expectHeaderValue;
            Header expectHeader;
            RequestLine requestLine = request.getRequestLine();
            HttpVersion requestVersion = requestLine.getHttpVersion();
            if (HttpVersion.HTTP_1_1.equals(requestVersion) && (expectHeader = request.getFirstHeader("Expect")) != null && "100-continue".equals(expectHeaderValue = expectHeader.getValue())) {
                HttpResponse expected = new HttpResponse();
                expected.setStatusLine(requestLine.getHttpVersion(), 100);
                DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)expected, OldHttpMessageReceiver.this.getEndpoint().getMuleContext()), (InboundEndpoint)OldHttpMessageReceiver.this.endpoint, OldHttpMessageReceiver.this.flowConstruct);
                RequestContext.setEvent((MuleEvent)event);
                this.conn.writeResponse(OldHttpMessageReceiver.this.transformResponse(expected, (MuleEvent)event));
            }
        }

        private HttpResponse buildFailureResponse(MuleEvent event, String description, int httpStatusCode) throws MuleException {
            event.getMessage().setOutboundProperty("http.status", (Object)httpStatusCode);
            event.getMessage().setPayload((Object)description);
            return OldHttpMessageReceiver.this.transformResponse(event.getMessage(), event);
        }

        protected HttpResponse buildFailureResponse(HttpVersion version, int statusCode, String description) throws MuleException {
            HttpResponse response = new HttpResponse();
            response.setStatusLine(version, statusCode);
            response.setBody(description);
            DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)response, OldHttpMessageReceiver.this.getEndpoint().getMuleContext()), (InboundEndpoint)OldHttpMessageReceiver.this.endpoint, OldHttpMessageReceiver.this.flowConstruct);
            RequestContext.setEvent((MuleEvent)event);
            return OldHttpMessageReceiver.this.transformResponse(response, (MuleEvent)event);
        }

        protected void preRouteMessage(MuleMessage message) throws MessagingException {
            message.setProperty("MULE_REMOTE_CLIENT_ADDRESS", (Object)this.remoteClientAddress, PropertyScope.INBOUND);
        }

        public void release() {
            this.conn.close();
            this.conn = null;
        }
    }
}

