/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.components;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEventContext;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.filter.Filter;
import org.mule.component.AbstractComponent;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.routing.filters.ExpressionFilter;
import org.mule.transport.NullPayload;
import org.mule.transport.http.components.RestServiceException;

public class RestServiceWrapper
extends AbstractComponent {
    public static final String DELETE = "DELETE";
    public static final String GET = "GET";
    public static final String CONTENT_TYPE_VALUE = "application/x-www-form-urlencoded";
    public static final String HTTP_METHOD = "http.method";
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String serviceUrl;
    private Map requiredParams = new HashMap();
    private Map optionalParams = new HashMap();
    private String httpMethod = "GET";
    private List payloadParameterNames;
    private Filter errorFilter;

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public Map getRequiredParams() {
        return this.requiredParams;
    }

    public void setRequiredParams(Map requiredParams) {
        this.requiredParams = requiredParams;
    }

    public Map getOptionalParams() {
        return this.optionalParams;
    }

    public void setOptionalParams(Map optionalParams) {
        this.optionalParams = optionalParams;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public List getPayloadParameterNames() {
        return this.payloadParameterNames;
    }

    public void setPayloadParameterNames(List payloadParameterNames) {
        this.payloadParameterNames = payloadParameterNames;
    }

    public Filter getFilter() {
        return this.errorFilter;
    }

    public void setFilter(Filter errorFilter) {
        this.errorFilter = errorFilter;
    }

    protected void doInitialise() throws InitialisationException {
        if (this.serviceUrl == null) {
            throw new InitialisationException(CoreMessages.objectIsNull((String)"serviceUrl"), (Initialisable)this);
        }
        if (!this.muleContext.getExpressionManager().isExpression(this.serviceUrl)) {
            try {
                new URL(this.serviceUrl);
            }
            catch (MalformedURLException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
        if (this.errorFilter == null) {
            this.errorFilter = new ExpressionFilter("#[header:INBOUND:http.status!=200]");
            this.logger.info((Object)"Setting default error filter to ExpressionFilter('#[header:INBOUND:http.status!=200]')");
        }
    }

    public Object doInvoke(MuleEvent event) throws Exception {
        Object requestBody;
        Object request = event.getMessage().getPayload();
        String tempUrl = this.serviceUrl;
        if (this.muleContext.getExpressionManager().isExpression(this.serviceUrl)) {
            this.muleContext.getExpressionManager().validateExpression(this.serviceUrl);
            tempUrl = this.muleContext.getExpressionManager().parse(this.serviceUrl, event, true);
        }
        StringBuilder urlBuffer = new StringBuilder(tempUrl);
        if (GET.equalsIgnoreCase(this.httpMethod) || DELETE.equalsIgnoreCase(this.httpMethod)) {
            requestBody = NullPayload.getInstance();
            this.setRESTParams(urlBuffer, event.getMessage(), request, this.requiredParams, false, null);
            this.setRESTParams(urlBuffer, event.getMessage(), request, this.optionalParams, true, null);
        } else {
            if (event.getMessage().getOutboundProperty("Content-Type") == null) {
                event.getMessage().setOutboundProperty("Content-Type", (Object)CONTENT_TYPE_VALUE);
            }
            StringBuilder requestBodyBuffer = new StringBuilder();
            this.setRESTParams(urlBuffer, event.getMessage(), request, this.requiredParams, false, requestBodyBuffer);
            this.setRESTParams(urlBuffer, event.getMessage(), request, this.optionalParams, true, requestBodyBuffer);
            requestBody = requestBodyBuffer.toString();
        }
        tempUrl = urlBuffer.toString();
        this.logger.info((Object)("Invoking REST service: " + tempUrl));
        event.getMessage().setOutboundProperty(HTTP_METHOD, (Object)this.httpMethod);
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(tempUrl, this.muleContext);
        endpointBuilder.setExchangePattern(MessageExchangePattern.REQUEST_RESPONSE);
        OutboundEndpoint outboundEndpoint = endpointBuilder.buildOutboundEndpoint();
        DefaultMuleEventContext eventContext = new DefaultMuleEventContext(event);
        MuleMessage result = eventContext.sendEvent((MuleMessage)new DefaultMuleMessage(requestBody, event.getMessage(), this.muleContext), outboundEndpoint);
        if (this.isErrorPayload(result)) {
            this.handleException(new RestServiceException(CoreMessages.failedToInvokeRestService((String)tempUrl), event), result);
        }
        return result;
    }

    private String getSeparator(String url) {
        String sep = url.indexOf("?") > -1 ? "&" : "?";
        return sep;
    }

    private String updateSeparator(String sep) {
        if (sep.compareTo("?") == 0 || sep.compareTo("") == 0) {
            return "&";
        }
        return sep;
    }

    private void setRESTParams(StringBuilder url, MuleMessage msg, Object body, Map args, boolean optional, StringBuilder requestBodyBuffer) {
        String sep = requestBodyBuffer == null ? this.getSeparator(url.toString()) : (requestBodyBuffer.length() > 0 ? "&" : "");
        for (Map.Entry entry : args.entrySet()) {
            String name = (String)entry.getKey();
            String exp = (String)entry.getValue();
            Object value = null;
            if (this.muleContext.getExpressionManager().isExpression(exp)) {
                this.muleContext.getExpressionManager().validateExpression(exp);
                try {
                    value = this.muleContext.getExpressionManager().evaluate(exp, msg);
                }
                catch (RequiredValueException e) {}
            } else {
                value = exp;
            }
            if (value == null) {
                if (!optional) {
                    throw new IllegalArgumentException(CoreMessages.propertyIsNotSetOnEvent((String)exp).toString());
                }
            } else if (requestBodyBuffer != null) {
                requestBodyBuffer.append(sep);
                requestBodyBuffer.append(name).append('=').append(value);
            } else {
                url.append(sep);
                url.append(name).append('=').append(value);
            }
            sep = this.updateSeparator(sep);
        }
        if (!optional && this.payloadParameterNames != null) {
            if (body instanceof Object[]) {
                Object[] requestArray = (Object[])body;
                for (int i = 0; i < this.payloadParameterNames.size(); ++i) {
                    if (requestBodyBuffer != null) {
                        requestBodyBuffer.append(sep).append(this.payloadParameterNames.get(i)).append('=').append(requestArray[i].toString());
                    } else {
                        url.append(sep).append(this.payloadParameterNames.get(i)).append('=').append(requestArray[i].toString());
                    }
                    sep = this.updateSeparator(sep);
                }
            } else if (this.payloadParameterNames.get(0) != null) {
                if (requestBodyBuffer != null) {
                    requestBodyBuffer.append(this.payloadParameterNames.get(0)).append('=').append(body.toString());
                } else {
                    url.append(sep).append(this.payloadParameterNames.get(0)).append('=').append(body.toString());
                }
            }
        }
    }

    protected boolean isErrorPayload(MuleMessage message) {
        return this.errorFilter != null && this.errorFilter.accept(message);
    }

    protected void handleException(RestServiceException e, MuleMessage result) throws Exception {
        throw e;
    }
}

