/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.bind;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.neo4j.server.bind.LazyBinding;
import org.neo4j.server.bind.LazyFactoryBinding;
import org.neo4j.server.bind.SingletonBinding;

public class ComponentsBinder
extends AbstractBinder {
    private final List<SingletonBinding> singletonBindings = new ArrayList<SingletonBinding>();
    private final List<LazyBinding> lazyBindings = new ArrayList<LazyBinding>();
    private final List<LazyFactoryBinding<?>> lazyFactoryBindings = new ArrayList();
    private boolean configured;

    public <T> void addSingletonBinding(T component, Class<T> type) {
        this.verifyBinding(component, type);
        this.singletonBindings.add(new SingletonBinding(component, type));
    }

    public void addLazyBinding(Supplier<?> componentSupplier, Class<?> type) {
        this.verifyBinding(componentSupplier, type);
        this.lazyBindings.add(new LazyBinding(componentSupplier, type));
    }

    public <T> void addLazyBinding(Class<? extends Supplier<T>> supplierType, Class<T> type) {
        this.verifyBinding(supplierType, type);
        this.lazyFactoryBindings.add(new LazyFactoryBinding<T>(supplierType, type));
    }

    protected void configure() {
        if (this.configured) {
            return;
        }
        this.configured = true;
        for (SingletonBinding singletonBinding : this.singletonBindings) {
            this.bind(singletonBinding.component()).to(singletonBinding.type());
        }
        for (LazyBinding lazyBinding : this.lazyBindings) {
            this.bindFactory(lazyBinding.supplier()).to(lazyBinding.type());
        }
        for (LazyFactoryBinding lazyFactoryBinding : this.lazyFactoryBindings) {
            this.bindFactory(lazyFactoryBinding.supplierType()).to(lazyFactoryBinding.type());
        }
    }

    private void verifyBinding(Object binding, Class<?> type) {
        Objects.requireNonNull(binding, "binding");
        Objects.requireNonNull(type, "type");
        if (this.configured) {
            throw new IllegalStateException("Unable to add new binding. Binder has already been configured");
        }
    }
}

