/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.output.eventsource;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.neo4j.server.http.cypher.TransactionHandle;
import org.neo4j.server.http.cypher.format.DefaultJsonFactory;
import org.neo4j.server.http.cypher.format.api.OutputEventSource;
import org.neo4j.server.http.cypher.format.jolt.JoltCodec;
import org.neo4j.server.http.cypher.format.output.eventsource.EventSourceSerializer;

@Provider
@Produces(value={"application/vnd.neo4j.jolt+json-seq;qs=0.5"})
public class EventSourceMessageBodyWriter
implements MessageBodyWriter<OutputEventSource> {
    public static final String JSON_JOLT_MIME_TYPE_VALUE = "application/vnd.neo4j.jolt+json-seq";
    public static final String JSON_JOLT_MIME_TYPE_VALUE_WITH_QUALITY = "application/vnd.neo4j.jolt+json-seq;qs=0.5";
    public static final MediaType JSON_JOLT_MIME_TYPE = MediaType.valueOf((String)"application/vnd.neo4j.jolt+json-seq");

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return OutputEventSource.class.isAssignableFrom(type);
    }

    public void writeTo(OutputEventSource outputEventSource, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream output) throws WebApplicationException {
        TransactionHandle transaction = outputEventSource.getTransactionHandle();
        Map<String, Object> parameters = outputEventSource.getParameters();
        boolean joltStrictModeEnabled = this.isJoltStrictModeEnabled(httpHeaders);
        JsonFactory jsonFactory = DefaultJsonFactory.INSTANCE.get();
        EventSourceSerializer serializer = new EventSourceSerializer(transaction, parameters, JoltCodec.class, joltStrictModeEnabled, jsonFactory, output);
        outputEventSource.produceEvents(serializer::handleEvent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isJoltStrictModeEnabled(MultivaluedMap<String, Object> httpHeaders) {
        Predicate<MediaType> isStrictJolt = s -> s.isCompatible(JSON_JOLT_MIME_TYPE) && Boolean.parseBoolean(s.getParameters().getOrDefault("strict", Boolean.FALSE.toString()));
        if (!httpHeaders.containsKey((Object)"Content-Type")) return false;
        if (!((List)httpHeaders.get((Object)"Content-Type")).stream().map(MediaType.class::cast).anyMatch(isStrictJolt)) return false;
        return true;
    }
}

