/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.consumer;

import java.util.Arrays;
import java.util.Map;
import org.neo4j.bolt.messaging.ResultConsumer;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.runtime.statemachine.StatementMetadata;
import org.neo4j.fabric.stream.summary.EmptyExecutionPlanDescription;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.server.http.cypher.OutputEventStream;
import org.neo4j.server.http.cypher.TransactionIndependentValueMapper;
import org.neo4j.server.http.cypher.consumer.OutputEventStreamRecordConsumer;
import org.neo4j.server.http.cypher.entity.HttpExecutionPlanDescription;
import org.neo4j.server.http.cypher.entity.HttpNotification;
import org.neo4j.server.http.cypher.entity.HttpQueryStatistics;
import org.neo4j.server.http.cypher.format.api.Statement;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

public class OutputEventStreamResultConsumer
implements ResultConsumer {
    private final TextValue READ_TEXT = Values.stringValue((String)"r");
    private final TextValue READ_WRITE_TEXT = Values.stringValue((String)"rw");
    private final TextValue WRITE_TEXT = Values.stringValue((String)"w");
    private final TextValue SCHEMA_WRITE_TEXT = Values.stringValue((String)"s");
    private static final String TYPE = "type";
    private static final String STATS = "stats";
    private static final String PROFILE = "profile";
    private static final String PLAN = "plan";
    private static final String NOTIFICATIONS = "notifications";
    private final OutputEventStream outputEventStream;
    private final Statement statement;
    private final StatementMetadata statementMetadata;
    private final TransactionIndependentValueMapper valueMapper;

    public OutputEventStreamResultConsumer(OutputEventStream outputEventStream, Statement statement, StatementMetadata statementMetadata, TransactionIndependentValueMapper valueMapper) {
        this.outputEventStream = outputEventStream;
        this.statement = statement;
        this.statementMetadata = statementMetadata;
        this.valueMapper = valueMapper;
    }

    public void consume(BoltResult t) throws Throwable {
        this.outputEventStream.writeStatementStart(this.statement, Arrays.asList((String[])this.statementMetadata.fieldNames().clone()));
        OutputEventStreamRecordConsumer outputEventStreamRecordConsumer = new OutputEventStreamRecordConsumer(t, this.outputEventStream, this.valueMapper);
        t.handleRecords((BoltResult.RecordConsumer)outputEventStreamRecordConsumer, -1L);
        QueryExecutionType queryExecutionType = this.extractQueryExecutionType(outputEventStreamRecordConsumer.metadataMap());
        QueryStatistics queryStatistics = HttpQueryStatistics.fromAnyValue(outputEventStreamRecordConsumer.metadataMap().getOrDefault(STATS, null));
        ExecutionPlanDescription executionPlanDescription = this.extractExecutionPlanDescription(outputEventStreamRecordConsumer.metadataMap());
        Iterable<Notification> notifications = HttpNotification.iterableFromAnyValue(outputEventStreamRecordConsumer.metadataMap().getOrDefault(NOTIFICATIONS, null));
        this.outputEventStream.writeStatementEnd(queryExecutionType, queryStatistics, executionPlanDescription, notifications);
    }

    public boolean hasMore() {
        return false;
    }

    private QueryExecutionType extractQueryExecutionType(Map<String, AnyValue> metaDataMap) {
        AnyValue queryType = metaDataMap.get(TYPE);
        if (metaDataMap.containsKey(PLAN)) {
            if (queryType.equals((Object)this.READ_TEXT)) {
                return QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_ONLY);
            }
            if (queryType.equals((Object)this.READ_WRITE_TEXT)) {
                return QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE);
            }
            if (queryType.equals((Object)this.WRITE_TEXT)) {
                return QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.WRITE);
            }
            if (queryType.equals((Object)this.SCHEMA_WRITE_TEXT)) {
                return QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.SCHEMA_WRITE);
            }
            return QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE);
        }
        if (metaDataMap.containsKey(PROFILE)) {
            if (queryType.equals((Object)this.READ_TEXT)) {
                return QueryExecutionType.profiled((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_ONLY);
            }
            if (queryType.equals((Object)this.READ_WRITE_TEXT)) {
                return QueryExecutionType.profiled((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE);
            }
            if (queryType.equals((Object)this.WRITE_TEXT)) {
                return QueryExecutionType.profiled((QueryExecutionType.QueryType)QueryExecutionType.QueryType.WRITE);
            }
            if (queryType.equals((Object)this.SCHEMA_WRITE_TEXT)) {
                return QueryExecutionType.profiled((QueryExecutionType.QueryType)QueryExecutionType.QueryType.SCHEMA_WRITE);
            }
            return QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE);
        }
        if (queryType.equals((Object)this.READ_TEXT)) {
            return QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_ONLY);
        }
        if (queryType.equals((Object)this.READ_WRITE_TEXT)) {
            return QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE);
        }
        if (queryType.equals((Object)this.WRITE_TEXT)) {
            return QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.WRITE);
        }
        if (queryType.equals((Object)this.SCHEMA_WRITE_TEXT)) {
            return QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.SCHEMA_WRITE);
        }
        return QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE);
    }

    private ExecutionPlanDescription extractExecutionPlanDescription(Map<String, AnyValue> metadataMap) {
        if (metadataMap.containsKey(PLAN)) {
            return HttpExecutionPlanDescription.fromAnyValue(metadataMap.get(PLAN));
        }
        if (metadataMap.containsKey(PROFILE)) {
            return HttpExecutionPlanDescription.fromAnyValue(metadataMap.get(PROFILE));
        }
        return new EmptyExecutionPlanDescription();
    }
}

