/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.server.http.cypher.TransitionalTxManagementKernelTransaction;
import org.neo4j.server.http.cypher.entity.HttpNode;
import org.neo4j.server.http.cypher.entity.HttpRelationship;
import org.neo4j.server.http.cypher.format.common.Neo4jJsonCodec;
import org.neo4j.test.mockito.mock.SpatialMocks;

class Neo4jJsonCodecTest {
    private Neo4jJsonCodec jsonCodec;
    private JsonGenerator jsonGenerator;

    Neo4jJsonCodecTest() {
    }

    @BeforeEach
    void init() {
        TransitionalTxManagementKernelTransaction context = (TransitionalTxManagementKernelTransaction)Mockito.mock(TransitionalTxManagementKernelTransaction.class);
        InternalTransaction internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        KernelTransactionImplementation kernelTransaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)internalTransaction.kernelTransaction()).thenReturn((Object)kernelTransaction);
        Mockito.when((Object)context.getInternalTransaction()).thenReturn((Object)internalTransaction);
        this.jsonCodec = new Neo4jJsonCodec();
        this.jsonGenerator = (JsonGenerator)Mockito.mock(JsonGenerator.class);
    }

    @Test
    void testEntityWriting() throws IOException {
        Entity entity = (Entity)Mockito.mock(Entity.class);
        Mockito.when((Object)entity.getAllProperties()).thenThrow(RuntimeException.class);
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.jsonCodec.writeValue(this.jsonGenerator, (Object)entity));
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.never())).writeEndObject();
    }

    @Test
    void testNodeWriting() throws IOException {
        Entity node = (Entity)Mockito.mock(HttpNode.class);
        Mockito.when((Object)node.getAllProperties()).thenThrow(RuntimeException.class);
        Assertions.assertThrows(RuntimeException.class, () -> this.jsonCodec.writeValue(this.jsonGenerator, (Object)node));
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator)).writeEndObject();
    }

    @Test
    void testRelationshipWriting() throws IOException {
        HttpRelationship relationship = (HttpRelationship)Mockito.mock(HttpRelationship.class);
        Mockito.when((Object)relationship.isDeleted()).thenReturn((Object)false);
        Mockito.when((Object)relationship.getAllProperties()).thenThrow(RuntimeException.class);
        Assertions.assertThrows(RuntimeException.class, () -> this.jsonCodec.writeValue(this.jsonGenerator, (Object)relationship));
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator)).writeEndObject();
    }

    @Test
    void testPathWriting() throws IOException {
        Path path = (Path)Mockito.mock(Path.class);
        Entity entity = (Entity)Mockito.mock(Entity.class);
        Mockito.when((Object)entity.getAllProperties()).thenThrow(RuntimeException.class);
        Mockito.when((Object)path.iterator()).thenReturn(Arrays.asList(entity).listIterator());
        Assertions.assertThrows(Exception.class, () -> this.jsonCodec.writeValue(this.jsonGenerator, (Object)path));
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator)).writeEndArray();
    }

    @Test
    void testIteratorWriting() throws IOException {
        Entity entity = (Entity)Mockito.mock(Entity.class);
        Mockito.when((Object)entity.getAllProperties()).thenThrow(RuntimeException.class);
        Assertions.assertThrows(Exception.class, () -> this.jsonCodec.writeValue(this.jsonGenerator, Collections.singletonList(entity)));
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator)).writeEndArray();
    }

    @Test
    void testByteArrayWriting() throws IOException {
        ((JsonGenerator)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.jsonGenerator)).writeNumber(ArgumentMatchers.anyInt());
        byte[] byteArray = new byte[]{1, 2, 3};
        this.jsonCodec.writeValue(this.jsonGenerator, (Object)byteArray);
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator)).writeEndArray();
    }

    @Test
    void testMapWriting() throws IOException {
        ((JsonGenerator)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.jsonGenerator)).writeFieldName(ArgumentMatchers.anyString());
        this.jsonCodec.writeValue(this.jsonGenerator, new HashMap());
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator)).writeEndObject();
    }

    @Test
    void shouldWriteAMapContainingNullAsKeysAndValues() throws IOException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(null, null);
        this.jsonCodec.writeValue(this.jsonGenerator, map);
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator)).writeFieldName("null");
    }

    @Test
    void testGeographicPointWriting() throws IOException {
        SpatialMocks.MockPoint value = SpatialMocks.mockPoint((double)12.3, (double)45.6, (CRS)SpatialMocks.mockWGS84());
        this.jsonCodec.writeValue(this.jsonGenerator, (Object)value);
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)3))).writeEndObject();
    }

    @Test
    void testGeographic3DPointWriting() throws IOException {
        SpatialMocks.MockPoint3D value = SpatialMocks.mockPoint((double)12.3, (double)45.6, (double)78.9, (CRS)SpatialMocks.mockWGS84_3D());
        this.jsonCodec.writeValue(this.jsonGenerator, (Object)value);
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)3))).writeEndObject();
    }

    @Test
    void testCartesianPointWriting() throws IOException {
        SpatialMocks.MockPoint value = SpatialMocks.mockPoint((double)123.0, (double)456.0, (CRS)SpatialMocks.mockCartesian());
        this.jsonCodec.writeValue(this.jsonGenerator, (Object)value);
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)3))).writeEndObject();
    }

    @Test
    void testCartesian3DPointWriting() throws IOException {
        SpatialMocks.MockPoint3D value = SpatialMocks.mockPoint((double)123.0, (double)456.0, (double)789.0, (CRS)SpatialMocks.mockCartesian_3D());
        this.jsonCodec.writeValue(this.jsonGenerator, (Object)value);
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)3))).writeEndObject();
    }

    @Test
    void testGeometryWriting() throws IOException {
        ArrayList<Coordinate> points = new ArrayList<Coordinate>();
        points.add(new Coordinate(new double[]{1.0, 2.0}));
        points.add(new Coordinate(new double[]{2.0, 3.0}));
        SpatialMocks.MockGeometry value = SpatialMocks.mockGeometry((String)"LineString", points, (CRS)SpatialMocks.mockCartesian());
        this.jsonCodec.writeValue(this.jsonGenerator, (Object)value);
        ((JsonGenerator)Mockito.verify((Object)this.jsonGenerator, (VerificationMode)Mockito.times((int)3))).writeEndObject();
    }

    @Test
    void testGeometryCrsStructureCartesian() throws IOException {
        this.verifyCRSStructure(SpatialMocks.mockCartesian());
    }

    @Test
    void testGeometryCrsStructureCartesian_3D() throws IOException {
        this.verifyCRSStructure(SpatialMocks.mockCartesian_3D());
    }

    @Test
    void testGeometryCrsStructureWGS84() throws IOException {
        this.verifyCRSStructure(SpatialMocks.mockWGS84());
    }

    @Test
    void testGeometryCrsStructureWGS84_3D() throws IOException {
        this.verifyCRSStructure(SpatialMocks.mockWGS84_3D());
    }

    private void verifyCRSStructure(CRS crs) throws IOException {
        this.jsonCodec.writeValue(this.jsonGenerator, (Object)crs);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.jsonGenerator});
        ((JsonGenerator)inOrder.verify((Object)this.jsonGenerator)).writeStartObject();
        ((JsonGenerator)inOrder.verify((Object)this.jsonGenerator)).writeFieldName("srid");
        ((JsonGenerator)inOrder.verify((Object)this.jsonGenerator)).writeNumber(crs.getCode());
        ((JsonGenerator)inOrder.verify((Object)this.jsonGenerator)).writeFieldName("name");
        ((JsonGenerator)inOrder.verify((Object)this.jsonGenerator)).writeString(crs.getType());
        ((JsonGenerator)inOrder.verify((Object)this.jsonGenerator)).writeFieldName("type");
        ((JsonGenerator)inOrder.verify((Object)this.jsonGenerator)).writeString("link");
        ((JsonGenerator)inOrder.verify((Object)this.jsonGenerator)).writeFieldName("properties");
        ((JsonGenerator)inOrder.verify((Object)this.jsonGenerator)).writeStartObject();
        ((JsonGenerator)inOrder.verify((Object)this.jsonGenerator)).writeFieldName("href");
        ((JsonGenerator)inOrder.verify((Object)this.jsonGenerator)).writeString(ArgumentMatchers.startsWith((String)crs.getHref()));
        ((JsonGenerator)inOrder.verify((Object)this.jsonGenerator)).writeFieldName("type");
        ((JsonGenerator)inOrder.verify((Object)this.jsonGenerator)).writeString("ogcwkt");
        ((JsonGenerator)inOrder.verify((Object)this.jsonGenerator, Mockito.times((int)2))).writeEndObject();
    }
}

