/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.jolt.v2;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.neo4j.graphdb.Relationship;
import org.neo4j.server.http.cypher.format.jolt.Sigil;

final class JoltRelationshipSerializerV2
extends StdSerializer<Relationship> {
    JoltRelationshipSerializerV2() {
        super(Relationship.class);
    }

    public void serialize(Relationship relationship, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject((Object)relationship);
        generator.writeFieldName(Sigil.RELATIONSHIP.getValue());
        generator.writeStartArray();
        generator.writeString(relationship.getElementId());
        generator.writeString(relationship.getStartNode().getElementId());
        generator.writeString(relationship.getType().name());
        generator.writeString(relationship.getEndNode().getElementId());
        Map properties = Optional.ofNullable(relationship.getAllProperties()).orElseGet(Map::of);
        generator.writeStartObject();
        for (Map.Entry entry : properties.entrySet()) {
            generator.writeFieldName((String)entry.getKey());
            generator.writeObject(entry.getValue());
        }
        generator.writeEndObject();
        generator.writeEndArray();
        generator.writeEndObject();
    }
}

