/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.facade.embedded.EmbeddedGraphDatabase;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.internal.locker.StoreLocker;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;

public class ImpermanentGraphDatabase
extends EmbeddedGraphDatabase {
    private static final boolean TRACK_UNCLOSED_DATABASE_INSTANCES = false;
    private static final Map<File, Exception> startedButNotYetClosed = new ConcurrentHashMap<File, Exception>();
    protected static final File PATH = new File("target/test-data/impermanent-db");

    @Deprecated
    public ImpermanentGraphDatabase() {
        this(new HashMap<String, String>());
    }

    public ImpermanentGraphDatabase(File storeDir) {
        this(storeDir, new HashMap<String, String>());
    }

    @Deprecated
    public ImpermanentGraphDatabase(Map<String, String> params) {
        this(PATH, params);
    }

    @Deprecated
    public ImpermanentGraphDatabase(File storeDir, Map<String, String> params) {
        this(storeDir, params, Iterables.cast((Iterable)Service.load(KernelExtensionFactory.class)));
    }

    @Deprecated
    public ImpermanentGraphDatabase(Map<String, String> params, Iterable<KernelExtensionFactory<?>> kernelExtensions) {
        this(PATH, params, kernelExtensions);
    }

    @Deprecated
    public ImpermanentGraphDatabase(File storeDir, Map<String, String> params, Iterable<KernelExtensionFactory<?>> kernelExtensions) {
        this(storeDir, params, ImpermanentGraphDatabase.getDependencies(kernelExtensions));
    }

    private static GraphDatabaseFacadeFactory.Dependencies getDependencies(Iterable<KernelExtensionFactory<?>> kernelExtensions) {
        return GraphDatabaseDependencies.newDependencies().kernelExtensions(kernelExtensions);
    }

    public ImpermanentGraphDatabase(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        super(storeDir, params, dependencies);
        ImpermanentGraphDatabase.trackUnclosedUse(storeDir);
    }

    public ImpermanentGraphDatabase(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        super(storeDir, config, dependencies);
        ImpermanentGraphDatabase.trackUnclosedUse(storeDir);
    }

    protected void create(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, CommunityEditionModule::new){

            protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
                return new ImpermanentPlatformModule(storeDir, config, this.databaseInfo, dependencies);
            }
        }.initFacade(storeDir, params, dependencies, (GraphDatabaseFacade)this);
    }

    private static void trackUnclosedUse(File storeDir) {
    }

    public void shutdown() {
        super.shutdown();
    }

    private static Config withForcedInMemoryConfiguration(Config config) {
        config.augment(GraphDatabaseSettings.ephemeral, "true");
        config.augmentDefaults(GraphDatabaseSettings.pagecache_memory, "8M");
        return config;
    }

    protected static class ImpermanentPlatformModule
    extends PlatformModule {
        public ImpermanentPlatformModule(File storeDir, Config config, DatabaseInfo databaseInfo, GraphDatabaseFacadeFactory.Dependencies dependencies) {
            super(storeDir, ImpermanentGraphDatabase.withForcedInMemoryConfiguration(config), databaseInfo, dependencies);
        }

        protected StoreLocker createStoreLocker() {
            return new StoreLocker(this.fileSystem, this.storeLayout);
        }

        protected FileSystemAbstraction createFileSystemAbstraction() {
            return new EphemeralFileSystemAbstraction();
        }

        protected LogService createLogService(LogProvider userLogProvider) {
            return new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)NullLogProvider.getInstance());
        }
    }
}

