/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.limited;

import java.io.File;
import java.util.Map;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.graphdb.mockfs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.limited.LimitedFilesystemAbstraction;

public class LimitedFileSystemGraphDatabase
extends ImpermanentGraphDatabase {
    private FileSystemAbstraction fs;
    private LimitedFilesystemAbstraction limitedFs;

    public LimitedFileSystemGraphDatabase(File storeDir) {
        super(storeDir);
    }

    @Override
    protected void create(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, CommunityEditionModule::new){

            protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
                return new ImpermanentGraphDatabase.ImpermanentPlatformModule(storeDir, config, this.databaseInfo, dependencies){

                    @Override
                    protected FileSystemAbstraction createFileSystemAbstraction() {
                        LimitedFileSystemGraphDatabase.this.fs = super.createFileSystemAbstraction();
                        LimitedFileSystemGraphDatabase.this.limitedFs = new LimitedFilesystemAbstraction((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(LimitedFileSystemGraphDatabase.this.fs));
                        return LimitedFileSystemGraphDatabase.this.limitedFs;
                    }
                };
            }
        }.initFacade(storeDir, params, dependencies, (GraphDatabaseFacade)this);
    }

    public void runOutOfDiskSpaceNao() {
        this.limitedFs.runOutOfDiskSpace(true);
    }

    public void somehowGainMoreDiskSpace() {
        this.limitedFs.runOutOfDiskSpace(false);
    }

    public FileSystemAbstraction getFileSystem() {
        return this.fs;
    }
}

