/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.time.Duration;
import org.neo4j.bolt.transport.pipeline.AuthenticationTimeoutHandler;
import org.neo4j.bolt.transport.pipeline.AuthenticationTimeoutTracker;
import org.neo4j.bolt.transport.pipeline.BytesAccumulator;
import org.neo4j.bolt.transport.pipeline.ChannelProtector;

public class UnauthenticatedChannelProtector
implements ChannelProtector {
    private final Duration channelTimeout;
    private final ChannelPipeline pipeline;
    private final long maxMessageSize;

    public UnauthenticatedChannelProtector(ChannelPipeline pipeline, Duration channelTimeout, long maxMessageSize) {
        this.channelTimeout = channelTimeout;
        this.pipeline = pipeline;
        this.maxMessageSize = maxMessageSize;
    }

    @Override
    public void afterChannelCreated() {
        this.pipeline.addLast(new ChannelHandler[]{new AuthenticationTimeoutTracker(this.channelTimeout)});
        this.pipeline.addLast(new ChannelHandler[]{new AuthenticationTimeoutHandler(this.channelTimeout)});
    }

    @Override
    public void beforeBoltProtocolInstalled() {
        this.pipeline.addLast(new ChannelHandler[]{new BytesAccumulator(this.maxMessageSize)});
    }

    @Override
    public void disable() {
        this.pipeline.remove(AuthenticationTimeoutTracker.class);
        this.pipeline.remove(AuthenticationTimeoutHandler.class);
        this.pipeline.remove(BytesAccumulator.class);
    }
}

