/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.MutableSet;

public interface StorageUtils {
    public static final Set<OpenOption> WRITE_OPTIONS = Set.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE);
    public static final Set<OpenOption> READ_OPTIONS = Set.of(StandardOpenOption.READ);
    public static final Set<OpenOption> APPEND_OPTIONS = Set.of(StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.CREATE);

    public static boolean hasCreateOption(Set<? extends OpenOption> options) {
        return options.contains(StandardOpenOption.CREATE) || options.contains(StandardOpenOption.CREATE_NEW);
    }

    public static Set<OpenOption> normalizeForRead(OpenOption ... options) throws IOException {
        return StorageUtils.normalizeForRead((Set<? extends OpenOption>)Sets.mutable.of((Object[])options));
    }

    public static Set<OpenOption> normalizeForRead(Set<? extends OpenOption> options) throws IOException {
        return StorageUtils.normalize(StandardOpenOption.READ, options);
    }

    public static Set<OpenOption> normalizeForWrite(OpenOption ... options) throws IOException {
        return StorageUtils.normalizeForWrite((Set<? extends OpenOption>)Sets.mutable.of((Object[])options));
    }

    public static Set<OpenOption> normalizeForWrite(Set<? extends OpenOption> options) throws IOException {
        return StorageUtils.normalize(StandardOpenOption.WRITE, options);
    }

    private static Set<OpenOption> normalize(OpenOption defaultOption, Set<? extends OpenOption> options) throws IOException {
        Objects.requireNonNull(defaultOption);
        MutableSet normalized = Sets.mutable.withAll(options);
        normalized.add((Object)defaultOption);
        String nonStandards = StorageUtils.nonStandards((Set<? extends OpenOption>)normalized);
        if (!nonStandards.isEmpty()) {
            throw new IOException("Unsupported OpenOption(s): " + nonStandards);
        }
        if (normalized.contains((Object)StandardOpenOption.SYNC)) {
            throw new IOException("Unsupported OpenOption: " + StandardOpenOption.SYNC);
        }
        if (normalized.contains((Object)StandardOpenOption.DSYNC)) {
            throw new IOException("Unsupported OpenOption: " + StandardOpenOption.DSYNC);
        }
        normalized.remove((Object)StandardOpenOption.SPARSE);
        normalized.remove((Object)StandardOpenOption.DELETE_ON_CLOSE);
        if (normalized.contains((Object)StandardOpenOption.CREATE) && normalized.contains((Object)StandardOpenOption.CREATE_NEW)) {
            normalized.remove((Object)StandardOpenOption.CREATE);
        }
        if (normalized.contains((Object)StandardOpenOption.READ) && normalized.contains((Object)StandardOpenOption.TRUNCATE_EXISTING)) {
            normalized.remove((Object)StandardOpenOption.TRUNCATE_EXISTING);
        }
        if (normalized.contains((Object)StandardOpenOption.CREATE) || normalized.contains((Object)StandardOpenOption.CREATE_NEW)) {
            normalized.add((Object)StandardOpenOption.WRITE);
        }
        if (normalized.contains((Object)StandardOpenOption.APPEND) || normalized.contains((Object)StandardOpenOption.TRUNCATE_EXISTING)) {
            normalized.add((Object)StandardOpenOption.WRITE);
        }
        if (normalized.contains((Object)StandardOpenOption.TRUNCATE_EXISTING) && normalized.contains((Object)StandardOpenOption.APPEND)) {
            normalized.remove((Object)StandardOpenOption.TRUNCATE_EXISTING);
            normalized.remove((Object)StandardOpenOption.APPEND);
        }
        if (normalized.contains((Object)StandardOpenOption.READ) && normalized.contains((Object)StandardOpenOption.WRITE)) {
            throw new IOException("Storage channels cannot be opened for both READ and WRITE operations");
        }
        return normalized;
    }

    private static String nonStandards(Set<? extends OpenOption> options) {
        return options.stream().filter(opt -> !(opt instanceof StandardOpenOption)).map(opt -> opt.getClass().getSimpleName()).collect(Collectors.joining(", "));
    }
}

