/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.Objects;
import org.neo4j.codegen.TypeReference;

public class Parameter {
    static final Parameter[] NO_PARAMETERS = new Parameter[0];
    private final TypeReference type;
    private final String name;

    public static Parameter param(Class<?> type, String name) {
        return Parameter.param(TypeReference.typeReference(type), name);
    }

    public static Parameter param(TypeReference type, String name) {
        return new Parameter(Objects.requireNonNull(type, "TypeReference"), Parameter.requireValidName(name));
    }

    private Parameter(TypeReference type, String name) {
        if (type == TypeReference.VOID) {
            throw new IllegalArgumentException("Variables cannot be declared as void.");
        }
        this.type = type;
        this.name = name;
    }

    public String toString() {
        return this.writeTo(new StringBuilder()).toString();
    }

    StringBuilder writeTo(StringBuilder result) {
        result.append("Parameter[ ");
        this.type.writeTo(result);
        return result.append(" ").append(this.name).append(" ]");
    }

    public TypeReference type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    static String requireValidName(String name) {
        int cp;
        if (name == null) {
            throw new NullPointerException("name");
        }
        Parameter.notKeyword(name);
        if (!Character.isJavaIdentifierStart(name.codePointAt(0))) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        for (int i = 0; i < name.length(); i += Character.charCount(cp)) {
            cp = name.codePointAt(i);
            if (Character.isJavaIdentifierPart(cp)) continue;
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        return name;
    }

    private static void notKeyword(String name) {
        switch (name) {
            case "abstract": 
            case "continue": 
            case "for": 
            case "new": 
            case "switch": 
            case "assert": 
            case "default": 
            case "goto": 
            case "package": 
            case "synchronized": 
            case "boolean": 
            case "do": 
            case "if": 
            case "private": 
            case "break": 
            case "double": 
            case "implements": 
            case "protected": 
            case "throw": 
            case "byte": 
            case "else": 
            case "import": 
            case "public": 
            case "throws": 
            case "case": 
            case "enum": 
            case "instanceof": 
            case "return": 
            case "transient": 
            case "catch": 
            case "extends": 
            case "int": 
            case "short": 
            case "try": 
            case "char": 
            case "final": 
            case "interface": 
            case "static": 
            case "void": 
            case "class": 
            case "finally": 
            case "long": 
            case "strictfp": 
            case "volatile": 
            case "const": 
            case "float": 
            case "native": 
            case "super": 
            case "while": {
                throw new IllegalArgumentException("'" + name + "' is a java keyword");
            }
            case "this": 
            case "null": 
            case "true": 
            case "false": {
                throw new IllegalArgumentException("'" + name + "' is a reserved name");
            }
        }
    }

    boolean isVarArg() {
        return false;
    }
}

