/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.codegen.LocalVariable;
import org.neo4j.codegen.TypeReference;

public class LocalVariables {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Map<String, LocalVariable> localVariables = new HashMap<String, LocalVariable>();

    LocalVariable createNew(TypeReference type, String name) {
        if (this.localVariables.containsKey(name)) {
            throw new IllegalStateException(String.format("Local variable %s already in scope", name));
        }
        LocalVariable localVariable = new LocalVariable(type, name, this.counter.getAndIncrement());
        this.localVariables.put(name, localVariable);
        if (type.simpleName().equals("double") || type.simpleName().equals("long")) {
            this.counter.incrementAndGet();
        }
        return localVariable;
    }

    public LocalVariable get(String name) {
        LocalVariable localVariable = this.localVariables.get(name);
        if (localVariable == null) {
            throw new NoSuchElementException("No variable " + name + " in scope");
        }
        return localVariable;
    }

    public static LocalVariables copy(LocalVariables original) {
        LocalVariables variables = new LocalVariables();
        variables.counter.set(original.counter.get());
        original.localVariables.forEach(variables.localVariables::put);
        return variables;
    }
}

