/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;

public abstract class ResourceClosingIterator<T, V>
implements ResourceIterator<V> {
    private Resource resource;
    private final Iterator<T> iterator;

    public static <R> ResourceIterator<R> newResourceIterator(Iterator<R> iterator, Resource resource) {
        return new ResourceClosingIterator<R, R>(iterator, resource){

            @Override
            public R map(R elem) {
                return elem;
            }
        };
    }

    public static <R> ResourceIterator<R> fromResourceIterable(ResourceIterable<R> iterable) {
        ResourceIterator iterator = iterable.iterator();
        return ResourceClosingIterator.newResourceIterator(iterator, iterable);
    }

    ResourceClosingIterator(Iterator<T> iterator, Resource resource) {
        this.resource = resource;
        this.iterator = iterator;
    }

    public void close() {
        if (this.resource != null) {
            this.resource.close();
            this.resource = null;
        }
    }

    public boolean hasNext() {
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext) {
            this.close();
        }
        return hasNext;
    }

    public abstract V map(T var1);

    public V next() {
        try {
            return this.map(this.iterator.next());
        }
        catch (NoSuchElementException e) {
            this.close();
            throw e;
        }
    }

    public void remove() {
        this.iterator.remove();
    }
}

