/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import org.junit.Rule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.migrationsupport.rules.EnableRuleMigrationSupport;
import org.junit.rules.ExpectedException;
import org.neo4j.helpers.Numbers;

@EnableRuleMigrationSupport
public class NumbersTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    void failSafeCastLongToInt() {
        this.expectedException.expect(ArithmeticException.class);
        this.expectedException.expectMessage("Value 2147483648 is too big to be represented as int");
        Numbers.safeCastLongToInt((long)0x80000000L);
    }

    @Test
    void failSafeCastLongToShort() {
        this.expectedException.expect(ArithmeticException.class);
        this.expectedException.expectMessage("Value 32768 is too big to be represented as short");
        Numbers.safeCastLongToShort((long)32768L);
    }

    @Test
    void failSafeCastIntToUnsignedShort() {
        this.expectedException.expect(ArithmeticException.class);
        this.expectedException.expectMessage("Value 131068 is too big to be represented as unsigned short");
        Numbers.safeCastIntToUnsignedShort((int)131068);
    }

    @Test
    void failSafeCastLongToByte() {
        this.expectedException.expect(ArithmeticException.class);
        this.expectedException.expectMessage("Value 128 is too big to be represented as byte");
        Numbers.safeCastLongToByte((long)128L);
    }

    @Test
    void failSafeCastIntToShort() {
        this.expectedException.expect(ArithmeticException.class);
        this.expectedException.expectMessage("Value 32768 is too big to be represented as short");
        Numbers.safeCastIntToShort((int)32768);
    }

    @Test
    void castLongToInt() {
        Assertions.assertEquals((int)1, (int)Numbers.safeCastLongToInt((long)1L));
        Assertions.assertEquals((int)10, (int)Numbers.safeCastLongToInt((long)10L));
        Assertions.assertEquals((int)-1, (int)Numbers.safeCastLongToInt((long)-1L));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)Numbers.safeCastLongToInt((long)Integer.MAX_VALUE));
        Assertions.assertEquals((int)Integer.MIN_VALUE, (int)Numbers.safeCastLongToInt((long)Integer.MIN_VALUE));
    }

    @Test
    void castLongToShort() {
        Assertions.assertEquals((int)1, (int)Numbers.safeCastLongToShort((long)1L));
        Assertions.assertEquals((int)10, (int)Numbers.safeCastLongToShort((long)10L));
        Assertions.assertEquals((int)-1, (int)Numbers.safeCastLongToShort((long)-1L));
        Assertions.assertEquals((short)Short.MAX_VALUE, (short)Numbers.safeCastLongToShort((long)32767L));
        Assertions.assertEquals((short)Short.MIN_VALUE, (short)Numbers.safeCastLongToShort((long)-32768L));
    }

    @Test
    void castIntToUnsignedShort() {
        Assertions.assertEquals((int)1, (int)Numbers.safeCastIntToUnsignedShort((int)1));
        Assertions.assertEquals((int)10, (int)Numbers.safeCastIntToUnsignedShort((int)10));
        Assertions.assertEquals((int)-1, (int)Numbers.safeCastIntToUnsignedShort((int)65535));
    }

    @Test
    void castIntToShort() {
        Assertions.assertEquals((int)1, (int)Numbers.safeCastIntToShort((int)1));
        Assertions.assertEquals((int)10, (int)Numbers.safeCastIntToShort((int)10));
        Assertions.assertEquals((short)Short.MAX_VALUE, (short)Numbers.safeCastIntToShort((int)Short.MAX_VALUE));
        Assertions.assertEquals((short)Short.MIN_VALUE, (short)Numbers.safeCastIntToShort((int)Short.MIN_VALUE));
    }

    @Test
    void castLongToByte() {
        Assertions.assertEquals((int)1, (int)Numbers.safeCastLongToByte((long)1L));
        Assertions.assertEquals((int)10, (int)Numbers.safeCastLongToByte((long)10L));
        Assertions.assertEquals((int)-1, (int)Numbers.safeCastLongToByte((long)-1L));
        Assertions.assertEquals((byte)127, (byte)Numbers.safeCastLongToByte((long)127L));
        Assertions.assertEquals((byte)-128, (byte)Numbers.safeCastLongToByte((long)-128L));
    }

    @Test
    void castUnsignedShortToInt() {
        Assertions.assertEquals((int)1, (int)Numbers.unsignedShortToInt((short)1));
        Assertions.assertEquals((int)Short.MAX_VALUE, (int)Numbers.unsignedShortToInt((short)Short.MAX_VALUE));
        Assertions.assertEquals((int)65535, (int)Numbers.unsignedShortToInt((short)-1));
    }
}

