/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.lifecycle;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class LifeRule
implements TestRule {
    private LifeSupport life = new LifeSupport();
    private final boolean autoStart;

    public LifeRule() {
        this(false);
    }

    public LifeRule(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    if (LifeRule.this.autoStart) {
                        LifeRule.this.start();
                    }
                    base.evaluate();
                    LifeRule.this.life.shutdown();
                }
                catch (Throwable failure) {
                    try {
                        LifeRule.this.life.shutdown();
                    }
                    catch (Throwable suppressed) {
                        failure.addSuppressed(suppressed);
                    }
                    throw failure;
                }
                finally {
                    LifeRule.this.life = new LifeSupport();
                }
            }
        };
    }

    public <T extends Lifecycle> T add(T instance) {
        return (T)this.life.add(instance);
    }

    public void init() {
        this.life.init();
    }

    public void start() {
        this.life.start();
    }

    public void stop() {
        this.life.stop();
    }

    public void shutdown() {
        this.life.shutdown();
    }
}

