/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.LongStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.memory.GlobalMemoryTracker;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.memory.ThreadSafePeakMemoryAllocationTracker;
import org.neo4j.test.Race;

class ThreadSafePeakMemoryAllocationTrackerTest {
    ThreadSafePeakMemoryAllocationTrackerTest() {
    }

    @Test
    void shouldRegisterConcurrentAllocationsAndDeallocations() throws Throwable {
        ThreadSafePeakMemoryAllocationTracker tracker = new ThreadSafePeakMemoryAllocationTracker((MemoryAllocationTracker)GlobalMemoryTracker.INSTANCE);
        Race race = new Race();
        race.addContestants(10, () -> {
            int i;
            for (i = 1; i < 100; ++i) {
                tracker.allocated((long)i);
                MatcherAssert.assertThat((Object)tracker.usedDirectMemory(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
            }
            for (i = 1; i < 100; ++i) {
                MatcherAssert.assertThat((Object)tracker.usedDirectMemory(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
                tracker.deallocated((long)i);
            }
        }, 1);
        race.go();
        Assertions.assertEquals((long)0L, (long)tracker.usedDirectMemory());
    }

    @Test
    void shouldRegisterPeakMemoryUsage() throws Throwable {
        ThreadSafePeakMemoryAllocationTracker tracker = new ThreadSafePeakMemoryAllocationTracker((MemoryAllocationTracker)GlobalMemoryTracker.INSTANCE);
        int threads = 200;
        long[] allocations = new long[threads];
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long sum = 0L;
        for (int i = 0; i < allocations.length; ++i) {
            allocations[i] = random.nextInt(1, 10000);
            sum += allocations[i];
        }
        Race race = new Race();
        int i = 0;
        while (i < threads) {
            int id = i++;
            race.addContestant(() -> tracker.allocated(allocations[id]));
        }
        race.go();
        long peakAfterAllocation = tracker.peakMemoryUsage();
        LongStream.of(allocations).forEach(arg_0 -> ((ThreadSafePeakMemoryAllocationTracker)tracker).deallocated(arg_0));
        long peakAfterDeallocation = tracker.peakMemoryUsage();
        LongStream.of(allocations).forEach(arg_0 -> ((ThreadSafePeakMemoryAllocationTracker)tracker).allocated(arg_0));
        tracker.allocated(10L);
        long peakAfterHigherReallocation = tracker.peakMemoryUsage();
        LongStream.of(allocations).forEach(arg_0 -> ((ThreadSafePeakMemoryAllocationTracker)tracker).deallocated(arg_0));
        tracker.deallocated(10L);
        long peakAfterFinalDeallocation = tracker.peakMemoryUsage();
        Assertions.assertEquals((long)sum, (long)peakAfterAllocation);
        Assertions.assertEquals((long)sum, (long)peakAfterDeallocation);
        Assertions.assertEquals((long)(sum + 10L), (long)peakAfterHigherReallocation);
        Assertions.assertEquals((long)(sum + 10L), (long)peakAfterFinalDeallocation);
    }
}

