/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.lifecycle;

import java.util.Arrays;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class Lifecycles {
    private Lifecycles() {
    }

    public static Lifecycle multiple(Iterable<? extends Lifecycle> lifecycles) {
        return new CombinedLifecycle(lifecycles);
    }

    public static Lifecycle multiple(Lifecycle ... lifecycles) {
        return Lifecycles.multiple(Arrays.asList(lifecycles));
    }

    private static class CombinedLifecycle
    implements Lifecycle {
        private final Iterable<? extends Lifecycle> lifecycles;

        CombinedLifecycle(Iterable<? extends Lifecycle> lifecycles) {
            this.lifecycles = lifecycles;
        }

        @Override
        public void init() throws Throwable {
            for (Lifecycle lifecycle : this.lifecycles) {
                lifecycle.init();
            }
        }

        @Override
        public void start() throws Throwable {
            for (Lifecycle lifecycle : this.lifecycles) {
                lifecycle.start();
            }
        }

        @Override
        public void stop() throws Throwable {
            for (Lifecycle lifecycle : this.lifecycles) {
                lifecycle.stop();
            }
        }

        @Override
        public void shutdown() throws Throwable {
            for (Lifecycle lifecycle : this.lifecycles) {
                lifecycle.shutdown();
            }
        }
    }
}

