/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.Objects;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaRule;

public class SchemaRuleKey {
    private final boolean isConstraint;
    private final boolean isUnique;
    private final SchemaDescriptor schema;

    public SchemaRuleKey(SchemaRule rule) {
        if (rule instanceof ConstraintDescriptor) {
            ConstraintDescriptor constraint = (ConstraintDescriptor)rule;
            this.isConstraint = true;
            this.isUnique = constraint.enforcesUniqueness();
        } else {
            IndexDescriptor index = (IndexDescriptor)rule;
            this.isConstraint = false;
            this.isUnique = index.isUnique();
        }
        this.schema = rule.schema();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaRuleKey that = (SchemaRuleKey)o;
        if (this.isConstraint != that.isConstraint) {
            return false;
        }
        if (this.isUnique != that.isUnique) {
            return false;
        }
        return this.schema.equals(that.schema);
    }

    public int hashCode() {
        return Objects.hash(this.isConstraint ? 1 : 0, this.isUnique ? 1 : 0, this.schema.hashCode());
    }
}

