/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.ast.factory.neo4j;

import java.io.IOException;
import java.nio.CharBuffer;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CodePointBuffer;
import org.antlr.v4.runtime.CodePointCharStream;
import org.neo4j.cypher.internal.ast.factory.neo4j.UnicodeEscapeReader;
import org.neo4j.cypher.internal.cst.factory.neo4j.CypherToken;
import org.neo4j.cypher.internal.parser.CypherLexer;
import org.neo4j.util.VisibleForTesting;

public class ReplaceUnicodeEscapeSequences {
    private static final int BUFFER_SIZE = 4096;

    public static CypherLexer fromString(String cypher) throws IOException {
        return ReplaceUnicodeEscapeSequences.fromString(cypher, 4096);
    }

    @VisibleForTesting
    public static CypherLexer fromString(String cypher, int maxBuffer) throws IOException {
        CodePointBuffer.Builder antlrBuffer = CodePointBuffer.builder((int)cypher.length());
        CharBuffer cb = CharBuffer.allocate(Math.min(maxBuffer, cypher.length()));
        try (UnicodeEscapeReader reader = new UnicodeEscapeReader(cypher);){
            while (reader.read(cb.clear()) != -1) {
                antlrBuffer.append(cb.flip());
            }
            CypherLexer lexer = new CypherLexer((CharStream)CodePointCharStream.fromBuffer((CodePointBuffer)antlrBuffer.build(), (String)"<unknown>"));
            lexer.setTokenFactory(CypherToken.factory(reader.offsetTable()));
            CypherLexer cypherLexer = lexer;
            return cypherLexer;
        }
    }
}

