/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.query;

import java.io.Serializable;
import org.neo4j.cypherdsl.query.AsString;
import org.neo4j.cypherdsl.query.Query;

public abstract class MatchExpression
implements AsString,
Serializable,
Cloneable {
    public static Path path() {
        return new Path();
    }

    public static Path path(String name) {
        Path path = new Path();
        path.pathName = name;
        return path;
    }

    public static FunctionPath shortestPath(String name) {
        Query.checkNull(name, "Name");
        FunctionPath functionPath = new FunctionPath();
        functionPath.function = "shortestPath";
        functionPath.pathName = name;
        return functionPath;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static class FunctionPath<T extends FunctionPath>
    extends MatchExpression {
        public String pathName;
        public String function;
        public String from = "";
        public String to = "";
        public Direction direction = Direction.BOTH;
        public Integer minHops;
        public Integer maxHops;

        public T out() {
            this.direction = Direction.OUT;
            return (T)this;
        }

        public T in() {
            this.direction = Direction.IN;
            return (T)this;
        }

        public T both() {
            this.direction = Direction.BOTH;
            return (T)this;
        }

        public T from(String from) {
            Query.checkEmpty(from, "From");
            this.from = from;
            return (T)this;
        }

        public T to(String to) {
            Query.checkEmpty(to, "To");
            this.to = to;
            return (T)this;
        }

        public T hops(Integer minHops, Integer maxHops) {
            if (minHops != null && minHops < 0) {
                throw new IllegalArgumentException("Minimum number of hops must be over zero");
            }
            if (maxHops != null && maxHops < 0) {
                throw new IllegalArgumentException("Maximum number of hops must be over zero");
            }
            this.minHops = minHops;
            this.maxHops = maxHops;
            return (T)this;
        }

        @Override
        public void asString(StringBuilder builder) {
            builder.append(this.pathName).append("=");
            builder.append(this.function).append('(');
            builder.append('(').append(this.from).append(')');
            builder.append(this.direction.equals((Object)Direction.IN) ? "<-" : "-");
            if (this.minHops != null || this.maxHops != null) {
                builder.append('[');
                if (this.minHops != null || this.maxHops != null) {
                    builder.append('*');
                    if (this.minHops != null) {
                        builder.append(this.minHops);
                    }
                    builder.append("..");
                    if (this.maxHops != null) {
                        builder.append(this.maxHops);
                    }
                }
                builder.append(']');
            }
            builder.append(this.direction.equals((Object)Direction.OUT) ? "->" : "-");
            builder.append('(').append(this.to).append(')');
            builder.append(')');
        }
    }

    public static class Link<T extends Link>
    extends AbstractPath<T> {
        public AbstractPath leftPath;

        @Override
        public void asString(StringBuilder builder) {
            this.leftPath.asString(builder);
            super.asString(builder);
        }
    }

    public static class Path<T extends Path>
    extends AbstractPath<T> {
        public String pathName;
        public String from = "";

        @Override
        public void asString(StringBuilder builder) {
            if (this.pathName != null) {
                builder.append(this.pathName).append('=');
            }
            builder.append('(').append(this.from).append(')');
            super.asString(builder);
        }

        public T from(String from) {
            this.from = from;
            return (T)this;
        }
    }

    public static class AbstractPath<T extends AbstractPath>
    extends MatchExpression {
        public String to = "";
        public Direction direction = Direction.BOTH;
        public String as;
        public String relationship;
        public boolean optional;
        public Integer minHops;
        public Integer maxHops;

        @Override
        public void asString(StringBuilder builder) {
            builder.append(this.direction.equals((Object)Direction.IN) ? "<-" : "-");
            if (this.as != null || this.relationship != null || this.optional || this.minHops != null || this.maxHops != null) {
                builder.append('[');
                if (this.as != null) {
                    builder.append(this.as);
                }
                if (this.optional) {
                    builder.append('?');
                }
                if (this.relationship != null) {
                    builder.append(':').append(this.relationship);
                }
                if (this.minHops != null || this.maxHops != null) {
                    builder.append('*');
                    if (this.minHops != null) {
                        builder.append(this.minHops);
                    }
                    builder.append("..");
                    if (this.maxHops != null) {
                        builder.append(this.maxHops);
                    }
                }
                builder.append(']');
            }
            builder.append(this.direction.equals((Object)Direction.OUT) ? "->" : "-");
            builder.append('(').append(this.to).append(')');
        }

        public T out() {
            this.direction = Direction.OUT;
            return (T)this;
        }

        public T in() {
            this.direction = Direction.IN;
            return (T)this;
        }

        public T both() {
            this.direction = Direction.BOTH;
            return (T)this;
        }

        public T out(String relationship) {
            this.direction = Direction.OUT;
            this.relationship = relationship;
            return (T)this;
        }

        public T in(String relationship) {
            this.direction = Direction.IN;
            this.relationship = relationship;
            return (T)this;
        }

        public T both(String relationship) {
            this.direction = Direction.BOTH;
            this.relationship = relationship;
            return (T)this;
        }

        public T as(String name) {
            Query.checkEmpty(name, "Name");
            this.as = name;
            return (T)this;
        }

        public T rel(Enum relationship) {
            Query.checkNull(relationship, "Relationship");
            this.relationship = relationship.name();
            return (T)this;
        }

        public T rel(String relationship) {
            Query.checkEmpty(relationship, "Relationship");
            this.relationship = relationship;
            return (T)this;
        }

        public T optional() {
            this.optional = true;
            return (T)this;
        }

        public T hops(Integer minHops, Integer maxHops) {
            if (minHops != null && minHops < 0) {
                throw new IllegalArgumentException("Minimum number of hops must be over zero");
            }
            if (maxHops != null && maxHops < 0) {
                throw new IllegalArgumentException("Maximum number of hops must be over zero");
            }
            this.minHops = minHops;
            this.maxHops = maxHops;
            return (T)this;
        }

        public T to(String to) {
            this.to = to;
            return (T)this;
        }

        public Link link() {
            Link link = new Link();
            link.leftPath = this;
            return link;
        }
    }

    public static enum Direction {
        BOTH,
        OUT,
        IN;

    }
}

