/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Optional;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.1")
public final class NamedPath
implements PatternElement,
Named {
    private final SymbolicName name;
    private final Visitable pattern;

    static OngoingDefinitionWithName named(String name) {
        return NamedPath.named(SymbolicName.of(name));
    }

    static OngoingDefinitionWithName named(SymbolicName name) {
        Assertions.notNull(name, "A name is required");
        return new Builder(name);
    }

    static OngoingShortestPathDefinitionWithName named(String name, FunctionInvocation.FunctionDefinition algorithm) {
        return new ShortestPathBuilder(SymbolicName.of(name), algorithm);
    }

    static OngoingShortestPathDefinitionWithName named(SymbolicName name, FunctionInvocation.FunctionDefinition algorithm) {
        Assertions.notNull(name, "A name is required");
        return new ShortestPathBuilder(name, algorithm);
    }

    private NamedPath(SymbolicName name, RelationshipPattern pattern) {
        this.name = name;
        this.pattern = pattern;
    }

    private NamedPath(SymbolicName name, FunctionInvocation algorithm) {
        this.name = name;
        this.pattern = algorithm;
    }

    @Override
    public Optional<SymbolicName> getSymbolicName() {
        return Optional.of(this.name);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.name.accept(visitor);
        Operator.EQUALS.accept(visitor);
        this.pattern.accept(visitor);
        visitor.leave(this);
    }

    private static class ShortestPathBuilder
    implements OngoingShortestPathDefinitionWithName {
        private final SymbolicName name;
        private final FunctionInvocation.FunctionDefinition algorithm;

        private ShortestPathBuilder(SymbolicName name, FunctionInvocation.FunctionDefinition algorithm) {
            this.name = name;
            this.algorithm = algorithm;
        }

        @Override
        public NamedPath definedBy(Relationship relationship) {
            return new NamedPath(this.name, FunctionInvocation.create(this.algorithm, relationship));
        }
    }

    private static class Builder
    implements OngoingDefinitionWithName {
        private final SymbolicName name;

        private Builder(SymbolicName name) {
            this.name = name;
        }

        @Override
        public NamedPath definedBy(RelationshipPattern pattern) {
            return new NamedPath(this.name, pattern);
        }
    }

    public static interface OngoingShortestPathDefinitionWithName {
        public NamedPath definedBy(Relationship var1);
    }

    public static interface OngoingDefinitionWithName {
        public NamedPath definedBy(RelationshipPattern var1);
    }
}

