/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.neo4j.cypherdsl.core.ConflictingParametersException;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.support.ReflectiveVisitor;
import org.neo4j.cypherdsl.core.support.Visitable;

final class ParameterCollectingVisitor
extends ReflectiveVisitor {
    private final Set<String> names = new TreeSet<String>();
    private final Map<String, Object> values = new TreeMap<String, Object>();
    private final Map<String, Set<Object>> erroneousParameters = new TreeMap<String, Set<Object>>();

    ParameterCollectingVisitor() {
    }

    @Override
    protected boolean preEnter(Visitable visitable) {
        return true;
    }

    @Override
    protected void postLeave(Visitable visitable) {
    }

    void enter(Parameter parameter) {
        Object oldValue;
        boolean knownParameterName = !this.names.add(parameter.getName());
        Object newValue = parameter.getValue();
        Object object = oldValue = knownParameterName && this.values.containsKey(parameter.getName()) ? this.values.get(parameter.getName()) : Parameter.NO_VALUE;
        if (parameter.hasValue()) {
            this.values.put(parameter.getName(), newValue);
        }
        if (knownParameterName && !Objects.equals(oldValue, newValue)) {
            Set conflictingObjects = this.erroneousParameters.computeIfAbsent(parameter.getName(), s -> {
                HashSet<Object> list = new HashSet<Object>();
                list.add(oldValue);
                return list;
            });
            conflictingObjects.add(newValue);
        }
    }

    ParameterInformation getResult() {
        if (!this.erroneousParameters.isEmpty()) {
            throw new ConflictingParametersException(this.erroneousParameters);
        }
        return new ParameterInformation(this.names, this.values);
    }

    static class ParameterInformation {
        final Set<String> names;
        final Map<String, Object> values;

        ParameterInformation(Set<String> names, Map<String, Object> values) {
            this.names = Collections.unmodifiableSet(names);
            this.values = Collections.unmodifiableMap(values);
        }
    }
}

