/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Operation;
import org.neo4j.cypherdsl.core.Operations;
import org.neo4j.cypherdsl.core.PropertyLookup;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.support.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Property
implements Expression {
    private final Named container;
    private final Expression containerReference;
    private final List<PropertyLookup> names;

    static Property create(Named parentContainer, String ... names) {
        SymbolicName requiredSymbolicName = Property.extractRequiredSymbolicName(parentContainer);
        return new Property(Optional.of(parentContainer), requiredSymbolicName, Property.createListOfChainedNames(names));
    }

    static Property create(Expression containerReference, String ... names) {
        Assertions.notNull(containerReference, "The property container is required.");
        return new Property(Optional.empty(), containerReference, Property.createListOfChainedNames(names));
    }

    static Property create(Named parentContainer, Expression lookup) {
        SymbolicName requiredSymbolicName = Property.extractRequiredSymbolicName(parentContainer);
        return new Property(Optional.of(parentContainer), requiredSymbolicName, Collections.singletonList(PropertyLookup.forExpression(lookup)));
    }

    static Property create(Expression containerReference, Expression lookup) {
        return new Property(Optional.empty(), containerReference, Collections.singletonList(PropertyLookup.forExpression(lookup)));
    }

    private static List<PropertyLookup> createListOfChainedNames(String ... names) {
        Assertions.notEmpty(names, "The properties name is required.");
        if (names.length == 1) {
            return Collections.singletonList(PropertyLookup.forName(names[0]));
        }
        return Arrays.stream(names).map(PropertyLookup::forName).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    Property(Optional<Named> container, Expression containerReference, List<PropertyLookup> names) {
        this.container = container.orElse(null);
        this.containerReference = containerReference;
        this.names = names;
    }

    @API(status=API.Status.INTERNAL)
    public List<PropertyLookup> getNames() {
        return this.names;
    }

    @API(status=API.Status.INTERNAL)
    Named getContainer() {
        return this.container;
    }

    public Operation to(Expression expression) {
        return Operations.set(this, expression);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.containerReference.accept(visitor);
        this.names.forEach(name -> name.accept(visitor));
        visitor.leave(this);
    }

    private static SymbolicName extractRequiredSymbolicName(Named parentContainer) {
        try {
            return parentContainer.getRequiredSymbolicName();
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("A property derived from a node or a relationship needs a parent with a symbolic name.");
        }
    }
}

