/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.BuiltInFunctions;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.support.TypedSubtree;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="2020.1.5")
public final class Reduction
extends TypedSubtree<Visitable> {
    static OngoingDefinitionWithVariable of(SymbolicName variable) {
        Assertions.notNull(variable, "A variable is required");
        return new Builder(variable);
    }

    private Reduction(Visitable ... children) {
        super(children);
    }

    private static final class ReductionPipeline
    implements Visitable {
        private final SymbolicName variable;
        private final Expression list;
        private final Expression expression;

        ReductionPipeline(SymbolicName variable, Expression list, Expression expression) {
            this.variable = variable;
            this.list = list;
            this.expression = expression;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.enter(this);
            this.variable.accept(visitor);
            Operator.IN.accept(visitor);
            this.list.accept(visitor);
            Operator.PIPE.accept(visitor);
            this.expression.accept(visitor);
            visitor.leave(this);
        }
    }

    private static class Builder
    implements OngoingDefinitionWithVariable,
    OngoingDefinitionWithList,
    OngoingDefinitionWithInitial,
    OngoingDefinitionWithReducer {
        private Expression accumulatorExpression;
        private final SymbolicName variable;
        private Expression listExpression;
        private Expression mapExpression;

        private Builder(SymbolicName variable) {
            this.variable = variable;
        }

        @Override
        public OngoingDefinitionWithList in(Expression list) {
            this.listExpression = list;
            return this;
        }

        @Override
        public OngoingDefinitionWithReducer map(Expression mapper) {
            this.mapExpression = mapper;
            return this;
        }

        @Override
        public OngoingDefinitionWithInitial accumulateOn(Expression accumulator) {
            this.accumulatorExpression = accumulator;
            return this;
        }

        @Override
        public FunctionInvocation withInitialValueOf(Expression initialValue) {
            Condition accumulatorAssignment = this.accumulatorExpression.isEqualTo(initialValue);
            ReductionPipeline reductionPipeline = new ReductionPipeline(this.variable, this.listExpression, this.mapExpression);
            Reduction reduction = new Reduction(new Visitable[]{accumulatorAssignment, reductionPipeline});
            return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.REDUCE, reduction);
        }
    }

    public static interface OngoingDefinitionWithInitial {
        public FunctionInvocation withInitialValueOf(Expression var1);
    }

    public static interface OngoingDefinitionWithReducer {
        public OngoingDefinitionWithInitial accumulateOn(Expression var1);
    }

    public static interface OngoingDefinitionWithList {
        public OngoingDefinitionWithReducer map(Expression var1);
    }

    public static interface OngoingDefinitionWithVariable {
        public OngoingDefinitionWithList in(Expression var1);
    }
}

