/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.renderer;

import java.util.Optional;
import java.util.function.BiConsumer;
import org.neo4j.cypherdsl.core.CompoundCondition;
import org.neo4j.cypherdsl.core.Create;
import org.neo4j.cypherdsl.core.ExistentialSubquery;
import org.neo4j.cypherdsl.core.KeyValueMapEntry;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.Merge;
import org.neo4j.cypherdsl.core.MergeAction;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.PropertyLookup;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.Set;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.neo4j.cypherdsl.core.renderer.DefaultVisitor;

class PrettyPrintingVisitor
extends DefaultVisitor {
    private final BiConsumer<StringBuilder, Integer> indentionProvider;
    private int indentationLevel;
    private boolean passedFirstReadingOrUpdatingClause;

    PrettyPrintingVisitor(Configuration.IndentStyle indentStyle, int indentSize) {
        this.indentionProvider = indentStyle == Configuration.IndentStyle.TAB ? (builder, width) -> {
            for (int i = 0; i < width; ++i) {
                builder.append("\t");
            }
        } : (builder, width) -> {
            for (int i = 0; i < width * indentSize; ++i) {
                builder.append(" ");
            }
        };
    }

    private void indent(int width) {
        this.indentionProvider.accept(this.builder, width);
    }

    @Override
    void enter(Where where) {
        if (this.currentVisitedElements.stream().noneMatch(visitable -> visitable instanceof Return)) {
            this.builder.append("\n");
            this.indent(this.indentationLevel);
            this.builder.append("WHERE ");
        } else {
            super.enter(where);
        }
    }

    @Override
    void enter(Return returning) {
        this.trimNewline();
        super.enter(returning);
    }

    @Override
    void enter(With with) {
        if (this.passedFirstReadingOrUpdatingClause) {
            this.trimNewline();
            this.indent(this.indentationLevel);
        }
        this.passedFirstReadingOrUpdatingClause = true;
        super.enter(with);
    }

    @Override
    void enter(Set set) {
        if (this.currentVisitedElements.stream().noneMatch(visitable -> visitable instanceof MergeAction)) {
            this.trimNewline();
            this.indent(this.indentationLevel);
        }
        super.enter(set);
    }

    @Override
    void enter(Match match) {
        if (this.passedFirstReadingOrUpdatingClause) {
            this.trimNewline();
            this.indent(this.indentationLevel);
        }
        this.passedFirstReadingOrUpdatingClause = true;
        super.enter(match);
    }

    @Override
    void enter(Create create) {
        if (this.passedFirstReadingOrUpdatingClause) {
            this.trimNewline();
        }
        this.passedFirstReadingOrUpdatingClause = true;
        super.enter(create);
    }

    @Override
    void enter(PropertyLookup propertyLookup) {
        if (this.currentVisitedElements.stream().skip(1L).limit(1L).anyMatch(visitable -> visitable instanceof MapExpression)) {
            this.trimNewline();
            this.indent(this.indentationLevel);
        }
        super.enter(propertyLookup);
    }

    @Override
    void enter(KeyValueMapEntry map) {
        if (this.indentationLevel > 0) {
            this.trimNewline();
            this.indent(this.indentationLevel);
        }
        super.enter(map);
    }

    @Override
    void enter(CompoundCondition operator) {
        ++this.indentationLevel;
        super.enter(operator);
    }

    @Override
    void leave(CompoundCondition operator) {
        --this.indentationLevel;
        super.leave(operator);
    }

    @Override
    void enter(Operator operator) {
        Operator.Type type = operator.getType();
        if (type == Operator.Type.LABEL) {
            return;
        }
        if (type != Operator.Type.PREFIX && operator != Operator.EXPONENTIATION) {
            this.builder.append(" ");
        }
        if (operator == Operator.OR || operator == Operator.AND || operator == Operator.XOR) {
            this.trimNewline();
            this.indent(this.indentationLevel);
        }
        this.builder.append(operator.getRepresentation());
        if (type != Operator.Type.POSTFIX && operator != Operator.EXPONENTIATION) {
            this.builder.append(" ");
        }
    }

    @Override
    void enter(MapExpression map) {
        ++this.indentationLevel;
        this.builder.append(" ");
        super.enter(map);
    }

    @Override
    void leave(MapExpression map) {
        --this.indentationLevel;
        this.trimNewline();
        this.indent(this.indentationLevel);
        super.leave(map);
    }

    @Override
    void enter(MergeAction onCreateOrMatchEvent) {
        this.trimNewline();
        this.indent(1);
        super.enter(onCreateOrMatchEvent);
    }

    @Override
    void enter(Merge merge) {
        if (this.passedFirstReadingOrUpdatingClause) {
            this.trimNewline();
            this.indent(this.indentationLevel);
        }
        this.passedFirstReadingOrUpdatingClause = true;
        super.enter(merge);
    }

    @Override
    void enter(ExistentialSubquery subquery) {
        super.enter(subquery);
        ++this.indentationLevel;
    }

    @Override
    void leave(ExistentialSubquery subquery) {
        --this.indentationLevel;
        this.trimNewline();
        this.indent(this.indentationLevel);
        this.builder.append("}");
    }

    private void trimNewline() {
        for (int i = this.builder.length() - 1; i >= 0 && this.builder.charAt(i) == ' '; --i) {
            this.builder.deleteCharAt(i);
        }
        this.builder.append("\n");
    }

    @Override
    protected Optional<String> escapeName(CharSequence unescapedName) {
        if (unescapedName == null) {
            return Optional.empty();
        }
        return Optional.of(super.escapeIfNecessary(unescapedName.toString()));
    }
}

