/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.querydsl;

import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Template;
import com.querydsl.core.types.Templates;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.ConstantParameterHolder;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.querydsl.CypherTemplates;
import org.neo4j.cypherdsl.core.querydsl.UnsupportedOperatorException;
import org.neo4j.cypherdsl.core.support.UnsupportedLiteralException;

@API(status=API.Status.INTERNAL, since="2021.1.0")
public final class CypherContext {
    private final Templates templates = CypherTemplates.DEFAULT;
    private final List<Expression> expressions = new ArrayList<Expression>();
    private final String TO_STRING_VALUE_OF_UNSUPPORTED = "'__UNSUPPORTED__'";
    private final Map<Object, Parameter<?>> parameters = new IdentityHashMap();

    public void add(Expression expression) {
        this.expressions.add(expression);
    }

    public Expression[] getExpressions() {
        return this.expressions.toArray(new Expression[this.expressions.size()]);
    }

    Template getTemplate(Operator op) {
        Template template = this.templates.getTemplate(op);
        for (Template.Element element : template.getElements()) {
            if (!"'__UNSUPPORTED__'".equals(element.toString())) continue;
            throw new UnsupportedOperatorException(op);
        }
        return template;
    }

    int getPrecedence(Operator op) {
        return this.templates.getPrecedence(op);
    }

    Parameter<?> getOrCreateParameterFor(Object object) {
        return this.parameters.computeIfAbsent(object, o -> {
            Object value;
            try {
                value = new ConstantParameterHolder(o);
            }
            catch (UnsupportedLiteralException e) {
                value = o;
            }
            return Cypher.anonParameter(value);
        });
    }
}

