/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Visitor;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ExpressionCondition;
import org.neo4j.cypherdsl.core.ForeignAdapter;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.querydsl.CypherContext;
import org.neo4j.cypherdsl.core.querydsl.ToCypherFormatStringVisitor;

@API(status=API.Status.INTERNAL, since="2021.1.0")
final class QueryDSLAdapter
implements ForeignAdapter<com.querydsl.core.types.Expression<?>> {
    private final com.querydsl.core.types.Expression<?> expression;

    QueryDSLAdapter(com.querydsl.core.types.Expression<?> expression) {
        this.expression = expression;
    }

    @Override
    public Condition asCondition() {
        if (!(this.expression instanceof Predicate)) {
            throw new IllegalArgumentException("Only Query-DSL predicates can be turned into Cypher-DSL's predicates.");
        }
        CypherContext context = new CypherContext();
        String formatString = (String)this.expression.accept((Visitor)ToCypherFormatStringVisitor.INSTANCE, (Object)context);
        return new ExpressionCondition(Cypher.raw(formatString, context.getExpressions()));
    }

    @Override
    public Expression asExpression() {
        CypherContext context = new CypherContext();
        String formatString = (String)this.expression.accept((Visitor)ToCypherFormatStringVisitor.INSTANCE, (Object)context);
        return Cypher.raw(formatString, context.getExpressions());
    }

    @Override
    public Node asNode() {
        if (!(this.expression instanceof Path)) {
            throw new IllegalArgumentException("Only Query-DSL paths can be turned into nodes.");
        }
        Path entityPath = (Path)this.expression;
        return Cypher.node(entityPath.getRoot().getType().getSimpleName(), new String[0]).named(entityPath.getMetadata().getName());
    }

    @Override
    @NotNull
    public Relationship asRelationship() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public SymbolicName asName() {
        if (!(this.expression instanceof Path)) {
            throw new IllegalArgumentException("Only Query-DSL paths can be turned into names.");
        }
        Path entityPath = (Path)this.expression;
        return Cypher.name(entityPath.getMetadata().getName());
    }
}

