/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.Case;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.internal.CaseElse;
import org.neo4j.cypherdsl.core.internal.CaseWhenThen;
import org.neo4j.cypherdsl.core.utils.CheckReturnValue;

abstract class AbstractCase
implements Case {
    private CaseElse caseElse;
    private final List<CaseWhenThen> caseWhenThens;
    private Optional<String> prefix = Optional.empty();
    private Optional<String> suffix = Optional.empty();

    public static Case create(@Nullable Expression expression) {
        return expression == null ? new GenericCaseImpl() : new SimpleCaseImpl(expression);
    }

    AbstractCase() {
        this(Collections.emptyList());
    }

    AbstractCase(List<CaseWhenThen> caseWhenThens) {
        this.caseWhenThens = new ArrayList<CaseWhenThen>(caseWhenThens);
    }

    abstract Expression getCaseExpression();

    void setCaseElse(CaseElse caseElse) {
        this.caseElse = caseElse;
    }

    @Override
    @NotNull
    @CheckReturnValue
    public Case.OngoingWhenThen when(Expression nextExpression) {
        return new DefaultOngoingWhenThen(nextExpression);
    }

    @Override
    public Optional<String> getPrefix() {
        return this.prefix;
    }

    @Override
    public Optional<String> getSuffix() {
        return this.suffix;
    }

    @Override
    @NotNull
    public Property property(String ... names) {
        this.prefix = Optional.of("(");
        this.suffix = Optional.of(")");
        return Case.super.property(names);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        if (this.getCaseExpression() != null) {
            this.getCaseExpression().accept(visitor);
        }
        this.caseWhenThens.forEach(caseWhenThen -> caseWhenThen.accept(visitor));
        if (this.caseElse != null) {
            this.caseElse.accept(visitor);
        }
        visitor.leave(this);
    }

    private final class DefaultOngoingWhenThen
    implements Case.OngoingWhenThen {
        final Expression whenExpression;

        private DefaultOngoingWhenThen(Expression whenExpression) {
            this.whenExpression = whenExpression;
        }

        @Override
        @NotNull
        @CheckReturnValue
        public Case.CaseEnding then(Expression expression) {
            CaseWhenThen caseWhenThen = new CaseWhenThen(this.whenExpression, expression);
            AbstractCase.this.caseWhenThens.add(caseWhenThen);
            if (AbstractCase.this.getCaseExpression() != null) {
                return new SimpleCaseImpl.EndingSimpleCase(AbstractCase.this.getCaseExpression(), AbstractCase.this.caseWhenThens);
            }
            return new GenericCaseImpl.EndingGenericCase(AbstractCase.this.caseWhenThens);
        }
    }

    static class GenericCaseImpl
    extends AbstractCase
    implements Case.GenericCase {
        GenericCaseImpl() {
            this(Collections.emptyList());
        }

        GenericCaseImpl(List<CaseWhenThen> caseWhenThens) {
            super(caseWhenThens);
        }

        @Override
        Expression getCaseExpression() {
            return null;
        }

        static final class EndingGenericCase
        extends GenericCaseImpl
        implements Case.CaseEnding {
            private EndingGenericCase(List<CaseWhenThen> caseWhenThens) {
                super(caseWhenThens);
            }

            @Override
            @NotNull
            public Case elseDefault(Expression defaultExpression) {
                this.setCaseElse(new CaseElse(defaultExpression));
                return this;
            }
        }
    }

    static class SimpleCaseImpl
    extends AbstractCase
    implements Case.SimpleCase {
        private final Expression caseExpression;

        SimpleCaseImpl(Expression caseExpression) {
            this(caseExpression, Collections.emptyList());
        }

        SimpleCaseImpl(Expression caseExpression, List<CaseWhenThen> caseWhenThens) {
            super(caseWhenThens);
            this.caseExpression = caseExpression;
        }

        @Override
        Expression getCaseExpression() {
            return this.caseExpression;
        }

        static final class EndingSimpleCase
        extends SimpleCaseImpl
        implements Case.CaseEnding {
            private EndingSimpleCase(Expression caseExpression, List<CaseWhenThen> caseWhenThens) {
                super(caseExpression, caseWhenThens);
            }

            @Override
            @NotNull
            public Case elseDefault(Expression defaultExpression) {
                this.setCaseElse(new CaseElse(defaultExpression));
                return this;
            }
        }
    }
}

