/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.time.Duration;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.build.annotations.RegisterForReflection;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ForeignAdapter;
import org.neo4j.cypherdsl.core.Literal;
import org.neo4j.cypherdsl.core.LiteralBase;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.IsoDuration;
import org.neo4j.driver.types.Point;
import org.neo4j.driver.types.TypeSystem;

@API(status=API.Status.INTERNAL, since="2023.2.1")
@RegisterForReflection(allDeclaredConstructors=true)
class DriverValueAdapter
implements ForeignAdapter<Value> {
    private final Value value;

    DriverValueAdapter(Value value) {
        this.value = value;
    }

    @Override
    @NotNull
    public Condition asCondition() {
        if (this.value.hasType(TypeSystem.getDefault().BOOLEAN())) {
            return this.asExpression().asCondition();
        }
        throw new UnsupportedOperationException("Only Boolean values can be adapted as condition");
    }

    @Override
    @NotNull
    public Expression asExpression() {
        return DriverValueAdapter.asExpression0(this.value);
    }

    private static Expression asExpression0(Value value) {
        TypeSystem typeSystem = TypeSystem.getDefault();
        if (value.hasType(typeSystem.NODE())) {
            throw new IllegalArgumentException("Node values can only be adapted with asNode");
        }
        if (value.hasType(typeSystem.RELATIONSHIP())) {
            throw new IllegalArgumentException("Relationship values can only be adapted with asRelationship");
        }
        if (value.hasType(typeSystem.POINT())) {
            Point p = value.asPoint();
            if (Double.isNaN(p.z())) {
                return new PointLiteral((Map<String, Object>)new TreeMap<String, Object>(Map.of("srid", p.srid(), "x", p.x(), "y", p.y())));
            }
            return new PointLiteral((Map<String, Object>)new TreeMap<String, Object>(Map.of("srid", p.srid(), "x", p.x(), "y", p.y(), "z", p.z())));
        }
        if (value.hasType(typeSystem.FLOAT())) {
            return DriverValueAdapter.asFloatOrDouble(value);
        }
        if (value.hasType(typeSystem.DURATION())) {
            IsoDuration d = value.asIsoDuration();
            return Cypher.literalOf(new TemporalAmountAdapter().apply((TemporalAmount)d));
        }
        if (value.hasType(typeSystem.BYTES())) {
            throw new IllegalArgumentException("byte[] values cannot be represented as expression.");
        }
        if (value.hasType(typeSystem.LIST())) {
            return Cypher.literalOf(value.asList(DriverValueAdapter::asExpression0));
        }
        if (value.hasType(typeSystem.MAP())) {
            return Cypher.literalOf(value.asMap(DriverValueAdapter::asExpression0));
        }
        return Cypher.literalOf(value.asObject());
    }

    private static Literal<Object> asFloatOrDouble(Value value) {
        Number number;
        try {
            number = Float.valueOf(value.asFloat());
        }
        catch (Exception e) {
            if (!"org.neo4j.driver.exceptions.value.LossyCoercion".equals(e.getClass().getName())) {
                throw e;
            }
            number = value.asDouble();
        }
        return Cypher.literalOf(number);
    }

    @Override
    @NotNull
    public Node asNode() {
        MapExpression properties;
        if (!this.value.hasType(TypeSystem.getDefault().NODE())) {
            throw new IllegalArgumentException("Cannot adopt value with type " + this.value.type().name() + " as node");
        }
        org.neo4j.driver.types.Node node = this.value.asNode();
        Iterable labels = node.labels();
        String primaryLabel = null;
        ArrayList<String> additionalLabels = new ArrayList<String>();
        for (String label : labels) {
            if (primaryLabel == null) {
                primaryLabel = label;
                continue;
            }
            additionalLabels.add(label);
        }
        MapExpression mapExpression = properties = node.size() == 0 ? null : MapExpression.create(node.asMap(DriverValueAdapter::asExpression0));
        if (primaryLabel != null) {
            return Cypher.node(primaryLabel, properties, additionalLabels);
        }
        return (Node)Cypher.anyNode().withProperties(properties);
    }

    @Override
    @NotNull
    public Relationship asRelationship() {
        if (!this.value.hasType(TypeSystem.getDefault().RELATIONSHIP())) {
            throw new IllegalArgumentException("Cannot adopt value with type " + this.value.type().name() + " as relationship");
        }
        org.neo4j.driver.types.Relationship relationship = this.value.asRelationship();
        MapExpression properties = relationship.size() == 0 ? null : MapExpression.create(relationship.asMap(DriverValueAdapter::asExpression0));
        return (Relationship)((Relationship)Cypher.anyNode().relationshipTo(Cypher.anyNode(), relationship.type())).withProperties(properties);
    }

    @Override
    @NotNull
    public SymbolicName asName() {
        throw new UnsupportedOperationException();
    }

    private static final class PointLiteral
    extends LiteralBase<Map<String, Object>> {
        private PointLiteral(Map<String, Object> content) {
            super(content);
        }

        @Override
        @NotNull
        public String asString() {
            return ((Map)this.content).entrySet().stream().map(e -> (String)e.getKey() + ": " + e.getValue()).collect(Collectors.joining(", ", "point({", "})"));
        }
    }

    static final class TemporalAmountAdapter
    implements UnaryOperator<TemporalAmount> {
        private static final int PERIOD_MASK = 28;
        private static final int DURATION_MASK = 3;
        private static final TemporalUnit[] SUPPORTED_UNITS = new TemporalUnit[]{ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.SECONDS, ChronoUnit.NANOS};
        private static final short FIELD_YEAR = 0;
        private static final short FIELD_MONTH = 1;
        private static final short FIELD_DAY = 2;
        private static final short FIELD_SECONDS = 3;
        private static final short FIELD_NANOS = 4;
        private static final BiFunction<TemporalAmount, TemporalUnit, Integer> TEMPORAL_UNIT_EXTRACTOR = (d, u) -> {
            if (!d.getUnits().contains(u)) {
                return 0;
            }
            return Math.toIntExact(d.get((TemporalUnit)u));
        };

        TemporalAmountAdapter() {
        }

        @Override
        public TemporalAmount apply(TemporalAmount internalTemporalAmountRepresentation) {
            int[] values = new int[SUPPORTED_UNITS.length];
            int type = 0;
            for (int i = 0; i < SUPPORTED_UNITS.length; ++i) {
                values[i] = TEMPORAL_UNIT_EXTRACTOR.apply(internalTemporalAmountRepresentation, SUPPORTED_UNITS[i]);
                type |= values[i] == 0 ? 0 : 16 >> i;
            }
            boolean couldBePeriod = TemporalAmountAdapter.couldBePeriod(type);
            boolean couldBeDuration = TemporalAmountAdapter.couldBeDuration(type);
            if (couldBePeriod && !couldBeDuration) {
                return Period.of(values[0], values[1], values[2]).normalized();
            }
            if (couldBeDuration && !couldBePeriod) {
                return Duration.ofSeconds(values[3]).plusNanos(values[4]);
            }
            return internalTemporalAmountRepresentation;
        }

        private static boolean couldBePeriod(int type) {
            return (0x1C & type) > 0;
        }

        private static boolean couldBeDuration(int type) {
            return (3 & type) > 0;
        }
    }
}

