/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.util.Locale;
import org.neo4j.cypher.internal.MapValueOps$;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.logging.Level;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.PrettyPrinter;
import org.neo4j.values.virtual.MapValue;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class AliasMapSettingsEvaluator$ {
    public static final AliasMapSettingsEvaluator$ MODULE$ = new AliasMapSettingsEvaluator$();

    public Map<String, AnyValue> org$neo4j$cypher$internal$AliasMapSettingsEvaluator$$convert(MapValue settings, String operation) {
        String ssl_enforced = "ssl_enforced";
        String connection_timeout = "connection_timeout";
        String connection_max_lifetime = "connection_max_lifetime";
        String connection_pool_acquisition_timeout = "connection_pool_acquisition_timeout";
        String connection_pool_idle_test = "connection_pool_idle_test";
        String connection_pool_max_size = "connection_pool_max_size";
        String logging_level = "logging_level";
        scala.collection.immutable.Set validKeys = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ssl_enforced, connection_timeout, connection_max_lifetime, connection_pool_acquisition_timeout, connection_pool_idle_test, connection_pool_max_size, logging_level}));
        scala.collection.immutable.Set invalidKeys = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.IterableHasAsScala(settings.keySet()).asScala().toSet().diff((Set)validKeys);
        if (invalidKeys.nonEmpty()) {
            throw InvalidArgumentsException.invalidDriverSettings((String)operation, (String)invalidKeys.mkString(", "), (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)validKeys.toList()).asJava());
        }
        return new .colon.colon((Object)((Tuple2)MapValueOps$.MODULE$.Ops(settings).getOption(ssl_enforced).map((Function1 & Serializable)x0$1 -> {
            AnyValue anyValue = x0$1;
            if (anyValue instanceof BooleanValue) {
                BooleanValue booleanValue = (BooleanValue)anyValue;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ssl_enforced), (Object)booleanValue);
            }
            throw AliasMapSettingsEvaluator$.throwExceptionWhenInvalidValue$1(ssl_enforced, "a boolean", "BOOLEAN", anyValue, operation);
        }).getOrElse((Function0 & Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ssl_enforced), (Object)Values.NO_VALUE))), (List)new .colon.colon((Object)AliasMapSettingsEvaluator$.getDurationSetting$1(connection_timeout, false, settings, operation), (List)new .colon.colon((Object)AliasMapSettingsEvaluator$.getDurationSetting$1(connection_max_lifetime, AliasMapSettingsEvaluator$.getDurationSetting$default$2$1(), settings, operation), (List)new .colon.colon((Object)AliasMapSettingsEvaluator$.getDurationSetting$1(connection_pool_acquisition_timeout, AliasMapSettingsEvaluator$.getDurationSetting$default$2$1(), settings, operation), (List)new .colon.colon((Object)AliasMapSettingsEvaluator$.getDurationSetting$1(connection_pool_idle_test, AliasMapSettingsEvaluator$.getDurationSetting$default$2$1(), settings, operation), (List)new .colon.colon((Object)AliasMapSettingsEvaluator$.getConnectionPoolMaxSize$1(settings, connection_pool_max_size, operation), (List)new .colon.colon((Object)AliasMapSettingsEvaluator$.getLoggingLevel$1(settings, logging_level, operation), (List)Nil$.MODULE$))))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final Nothing$ throwExceptionWhenInvalidValue$1(String key, String expectedType, String expectedCypherType, AnyValue invalidValue, String operation$3) {
        PrettyPrinter pp = new PrettyPrinter();
        invalidValue.writeTo((AnyValueWriter)pp);
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N27((String)pp.value(), (String)key, java.util.List.of(expectedCypherType));
        throw new InvalidArgumentsException(gql, "Failed to " + operation$3 + ": Invalid driver settings value for '" + key + "'. Expected " + expectedType + " value.");
    }

    private static final Tuple2 getDurationSetting$1(String key, boolean allowNegative, MapValue settings$1, String operation$3) {
        return (Tuple2)MapValueOps$.MODULE$.Ops(settings$1).getOption(key).map((Function1 & Serializable)x0$1 -> {
            AnyValue anyValue = x0$1;
            if (anyValue instanceof DurationValue) {
                DurationValue durationValue = (DurationValue)anyValue;
                if (!allowNegative && durationValue.compareTo(DurationValue.ZERO) < 0) {
                    throw new InvalidArgumentsException("Failed to " + operation$3 + ": Invalid driver settings value for '" + key + "'. Negative duration is not allowed.");
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)durationValue);
            }
            throw AliasMapSettingsEvaluator$.throwExceptionWhenInvalidValue$1(key, "a duration", "DURATION", anyValue, operation$3);
        }).getOrElse((Function0 & Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)Values.NO_VALUE));
    }

    private static final boolean getDurationSetting$default$2$1() {
        return true;
    }

    private static final /* synthetic */ TextValue liftedTree1$1(StringValue x2$1, String operation$3, String logging_level$1) {
        TextValue textValue;
        try {
            Level.valueOf((String)x2$1.stringValue().toUpperCase(Locale.ROOT));
            textValue = x2$1.toUpper();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw InvalidArgumentsException.unexpectedDriverSettingValue((String)operation$3, (String)String.valueOf(x2$1), (String)logging_level$1, (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])Level.values()), (Function1 & Serializable)value -> String.valueOf(value), ClassTag$.MODULE$.apply(String.class))).toList()).asJava());
        }
        return textValue;
    }

    private static final Tuple2 getLoggingLevel$1(MapValue settings$1, String logging_level$1, String operation$3) {
        return (Tuple2)MapValueOps$.MODULE$.Ops(settings$1).getOption(logging_level$1).map((Function1 & Serializable)x0$1 -> {
            AnyValue anyValue = x0$1;
            if (anyValue instanceof StringValue) {
                StringValue stringValue = (StringValue)anyValue;
                return new Tuple2((Object)logging_level$1, (Object)AliasMapSettingsEvaluator$.liftedTree1$1(stringValue, operation$3, logging_level$1));
            }
            throw AliasMapSettingsEvaluator$.throwExceptionWhenInvalidValue$1(logging_level$1, "a string", "STRING", anyValue, operation$3);
        }).getOrElse((Function0 & Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logging_level$1), (Object)Values.NO_VALUE));
    }

    private static final Tuple2 getConnectionPoolMaxSize$1(MapValue settings$1, String connection_pool_max_size$1, String operation$3) {
        return (Tuple2)MapValueOps$.MODULE$.Ops(settings$1).getOption(connection_pool_max_size$1).map((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            IntegralValue integralValue = null;
            AnyValue anyValue = x0$1;
            if (anyValue instanceof IntegralValue) {
                bl = true;
                integralValue = (IntegralValue)anyValue;
                if (integralValue.equals(0L)) {
                    throw InvalidArgumentsException.connectionPoolSizeZeroNotAllowed((String)operation$3, (String)connection_pool_max_size$1);
                }
            }
            if (bl) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)connection_pool_max_size$1), (Object)integralValue);
            }
            throw AliasMapSettingsEvaluator$.throwExceptionWhenInvalidValue$1(connection_pool_max_size$1, "an integer", "INTEGER", anyValue, operation$3);
        }).getOrElse((Function0 & Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)connection_pool_max_size$1), (Object)Values.NO_VALUE));
    }

    private AliasMapSettingsEvaluator$() {
    }
}

