/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.Closeable;
import java.io.IOException;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.dbms.LockChecker;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.ConfigUtils;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.internal.locker.FileLockException;
import picocli.CommandLine;

@CommandLine.Command(name="unbind", header={"Removes server identifier."}, description={"Removes server identifier. Next start instance will create a new identity for itself."})
public class UnbindCommand
extends AbstractCommand {
    public UnbindCommand(ExecutionContext ctx) {
        super(ctx);
    }

    public void execute() {
        try {
            Config config = this.buildConfig();
            Neo4jLayout neo4jLayout = Neo4jLayout.of((Config)config);
            try (Closeable ignored = LockChecker.checkDbmsLock((Neo4jLayout)neo4jLayout);){
                this.execute(config, neo4jLayout);
            }
        }
        catch (FileLockException e) {
            throw new CommandFailedException("Database is currently locked. Please shutdown database.", (Throwable)e);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void execute(Config config, Neo4jLayout neo4jLayout) throws IOException {
        this.ctx.fs().deleteFile(neo4jLayout.serverIdFile());
    }

    private Config buildConfig() {
        Config cfg = Config.newBuilder().fromFileNoThrow(this.ctx.confDir().resolve("neo4j.conf")).commandExpansion(this.allowCommandExpansion).set(GraphDatabaseSettings.neo4j_home, (Object)this.ctx.homeDir()).build();
        ConfigUtils.disableAllConnectors((Config)cfg);
        return cfg;
    }
}

