/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.util.function.Supplier;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.PageCacheWarmer;
import org.neo4j.kernel.impl.pagecache.PageCacheWarmerMonitor;
import org.neo4j.kernel.impl.pagecache.WarmupAvailabilityListener;
import org.neo4j.kernel.impl.transaction.state.NeoStoreFileListing;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.JobScheduler;

class PageCacheWarmerKernelExtension
extends LifecycleAdapter {
    private final AvailabilityGuard availabilityGuard;
    private final Supplier<NeoStoreFileListing> fileListing;
    private final Config config;
    private final PageCacheWarmer pageCacheWarmer;
    private final WarmupAvailabilityListener availabilityListener;
    private volatile boolean started;

    PageCacheWarmerKernelExtension(JobScheduler scheduler, AvailabilityGuard availabilityGuard, PageCache pageCache, FileSystemAbstraction fs, Supplier<NeoStoreFileListing> fileListing, Log log, PageCacheWarmerMonitor monitor, Config config) {
        this.availabilityGuard = availabilityGuard;
        this.fileListing = fileListing;
        this.config = config;
        this.pageCacheWarmer = new PageCacheWarmer(fs, pageCache, scheduler);
        this.availabilityListener = new WarmupAvailabilityListener(scheduler, this.pageCacheWarmer, config, log, monitor);
    }

    public void start() {
        if (((Boolean)this.config.get(GraphDatabaseSettings.pagecache_warmup_enabled)).booleanValue()) {
            this.pageCacheWarmer.start();
            this.availabilityGuard.addListener((AvailabilityGuard.AvailabilityListener)this.availabilityListener);
            this.fileListing.get().registerStoreFileProvider((NeoStoreFileListing.StoreFileProvider)this.pageCacheWarmer);
            this.started = true;
        }
    }

    public void stop() throws Throwable {
        if (this.started) {
            this.availabilityGuard.removeListener((AvailabilityGuard.AvailabilityListener)this.availabilityListener);
            this.availabilityListener.unavailable();
            this.pageCacheWarmer.stop();
            this.started = false;
        }
    }
}

