/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.util.function.Supplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.pagecache.PageCacheWarmer;
import org.neo4j.kernel.impl.pagecache.PageCacheWarmerKernelExtension;
import org.neo4j.kernel.impl.pagecache.PageCacheWarmerMonitor;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.transaction.state.NeoStoreFileListing;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.JobScheduler;

public class PageCacheWarmerKernelExtensionFactory
extends KernelExtensionFactory<Dependencies> {
    public PageCacheWarmerKernelExtensionFactory() {
        super("pagecachewarmer");
    }

    public Lifecycle newInstance(KernelContext context, Dependencies deps) {
        JobScheduler scheduler = deps.jobScheduler();
        AvailabilityGuard availabilityGuard = deps.availabilityGuard();
        PageCache pageCache = deps.pageCache();
        FileSystemAbstraction fs = deps.fileSystemAbstraction();
        Supplier<NeoStoreFileListing> fileListing = deps::fileListing;
        LogService logService = deps.logService();
        Log log = logService.getInternalLog(PageCacheWarmer.class);
        PageCacheWarmerMonitor monitor = (PageCacheWarmerMonitor)deps.monitors().newMonitor(PageCacheWarmerMonitor.class, new String[0]);
        Config config = deps.config();
        return new PageCacheWarmerKernelExtension(scheduler, availabilityGuard, pageCache, fs, fileListing, log, monitor, config);
    }

    public static interface Dependencies {
        public JobScheduler jobScheduler();

        public AvailabilityGuard availabilityGuard();

        public PageCache pageCache();

        public FileSystemAbstraction fileSystemAbstraction();

        public NeoStoreFileListing fileListing();

        public LogService logService();

        public Monitors monitors();

        public Config config();
    }
}

