/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Arrays;
import org.apache.lucene.queryparser.classic.ParseException;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.fulltext.ScoreEntityIterator;
import org.neo4j.values.storable.Value;

class TransactionStateFulltextIndexReader
extends FulltextIndexReader {
    private final FulltextIndexReader baseReader;
    private final FulltextIndexReader nearRealTimeReader;
    private final MutableLongSet modifiedEntityIdsInThisTransaction;

    TransactionStateFulltextIndexReader(FulltextIndexReader baseReader, FulltextIndexReader nearRealTimeReader, MutableLongSet modifiedEntityIdsInThisTransaction) {
        this.baseReader = baseReader;
        this.nearRealTimeReader = nearRealTimeReader;
        this.modifiedEntityIdsInThisTransaction = modifiedEntityIdsInThisTransaction;
    }

    @Override
    public ScoreEntityIterator query(String query) throws ParseException {
        ScoreEntityIterator iterator = this.baseReader.query(query);
        iterator = iterator.filter(entry -> !this.modifiedEntityIdsInThisTransaction.contains(entry.entityId()));
        iterator = ScoreEntityIterator.mergeIterators(Arrays.asList(iterator, this.nearRealTimeReader.query(query)));
        return iterator;
    }

    public long countIndexedNodes(long nodeId, int[] propertyKeyIds, Value ... propertyValues) {
        return 0L;
    }

    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new FulltextIndexReader[]{this.nearRealTimeReader});
    }
}

