/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.OffHeapRegularNumberArray;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.memory.MemoryTracker;

public class OffHeapIntArray
extends OffHeapRegularNumberArray<IntArray>
implements IntArray {
    private final int defaultValue;

    public OffHeapIntArray(long length, int defaultValue, long base, MemoryTracker memoryTracker) {
        super(length, 2, base, memoryTracker);
        this.defaultValue = defaultValue;
        this.clear();
    }

    @Override
    public int get(long index) {
        return UnsafeUtil.getInt((long)this.addressOf(index));
    }

    @Override
    public void set(long index, int value) {
        UnsafeUtil.putInt((long)this.addressOf(index), (int)value);
    }

    @Override
    public void clear() {
        if (this.isByteUniform(this.defaultValue)) {
            UnsafeUtil.setMemory((long)this.address, (long)(this.length << this.shift), (byte)((byte)this.defaultValue));
        } else {
            long i = 0L;
            long adr = this.address;
            while (i < this.length) {
                UnsafeUtil.putInt((long)adr, (int)this.defaultValue);
                ++i;
                adr += (long)this.itemSize;
            }
        }
    }
}

