/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.PrintStream;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.PrintConfig;
import org.neo4j.index.internal.gbptree.TreeState;
import org.neo4j.index.internal.gbptree.ValueHolder;

public class PrintingGBPTreeVisitor<ROOT_KEY, KEY, VALUE>
extends GBPTreeVisitor.Adaptor<ROOT_KEY, KEY, VALUE> {
    private final PrintStream out;
    private final boolean printValues;
    private final boolean printPosition;
    private final boolean printState;
    private final boolean printHeader;
    private final boolean printFreelist;
    private final boolean printOffload;
    private final boolean printHistory;

    public PrintingGBPTreeVisitor(PrintConfig printConfig) {
        this.out = printConfig.getPrintStream();
        this.printValues = printConfig.getPrintValues();
        this.printPosition = printConfig.getPrintPosition();
        this.printState = printConfig.getPrintState();
        this.printHeader = printConfig.getPrintHeader();
        this.printFreelist = printConfig.getPrintFreelist();
        this.printOffload = printConfig.getPrintOffload();
        this.printHistory = printConfig.getPrintHistory();
    }

    @Override
    public void treeState(Pair<TreeState, TreeState> statePair) {
        if (this.printState) {
            this.out.println("StateA: " + String.valueOf(statePair.getLeft()));
            this.out.println("StateB: " + String.valueOf(statePair.getRight()));
        }
    }

    @Override
    public void beginLevel(int level) {
        this.out.println("Level " + level);
    }

    @Override
    public void beginNode(long pageId, boolean isLeaf, long generation, int keyCount) {
        if (this.printHeader) {
            String treeNodeType = isLeaf ? "leaf" : "internal";
            this.out.printf("{%d,%s,generation=%d,keyCount=%d} ", pageId, treeNodeType, generation, keyCount);
        } else {
            this.out.print("{" + pageId + "} ");
        }
    }

    @Override
    public void position(int i) {
        if (this.printPosition) {
            this.out.print("#" + i + " ");
        }
    }

    @Override
    public void key(KEY key, boolean isLeaf, long offloadId) {
        boolean doPrintOffload = this.printOffload && offloadId != -1L;
        this.out.print(doPrintOffload ? "__" + offloadId + "__" + String.valueOf(key) : key);
    }

    @Override
    public void value(ValueHolder<VALUE> value) {
        if (this.printValues) {
            this.out.print("=" + String.valueOf(value.value) + (value.defined ? "[D]" : "[U]"));
        }
        this.out.print(" ");
    }

    @Override
    public boolean visitHistory() {
        return this.printHistory;
    }

    @Override
    public void historyStart() {
        if (this.printHistory) {
            this.out.print("History <");
        }
    }

    @Override
    public void historyEnd() {
        if (this.printHistory) {
            this.out.print(" > ");
        }
    }

    @Override
    public void historicalValue(long version, ValueHolder<VALUE> value) {
        if (this.printHistory) {
            this.out.print(" " + version + ":" + String.valueOf(value.value) + (value.defined ? "[D]" : "[U]"));
        }
    }

    @Override
    public void child(long child) {
        this.out.print(" /" + child + "\\ ");
    }

    @Override
    public void endNode(long pageId) {
        this.out.println();
    }

    @Override
    public void beginFreelistPage(long pageId) {
        if (this.printFreelist) {
            this.out.print("Freelist{" + pageId + "} ");
        }
    }

    @Override
    public void endFreelistPage(long pageId) {
        if (this.printFreelist) {
            this.out.println();
        }
    }

    @Override
    public void freelistEntry(long pageId, long generation, int pos) {
        if (this.printFreelist) {
            this.out.print("[" + generation + "," + pageId + "] ");
        }
    }
}

