/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries;

import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.StackTraceElementGuardedAdversary;

public class MethodGuardedAdversary
extends StackTraceElementGuardedAdversary {
    public MethodGuardedAdversary(Adversary delegate, final Method ... victimMethodSet) {
        super(delegate, new Predicate<StackTraceElement>(){
            private final Set<String> victimMethods;
            {
                this.victimMethods = Stream.of(victimMethodSet).map(Method::getName).collect(Collectors.toSet());
            }

            @Override
            public boolean test(StackTraceElement stackTraceElement) {
                return this.victimMethods.contains(stackTraceElement.getMethodName());
            }
        });
    }
}

