/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries;

import java.util.function.Predicate;
import org.neo4j.adversaries.Adversary;

public class StackTraceElementGuardedAdversary
implements Adversary {
    private final Adversary delegate;
    private final Predicate<StackTraceElement>[] checks;
    private volatile boolean enabled;

    @SafeVarargs
    public StackTraceElementGuardedAdversary(Adversary delegate, Predicate<StackTraceElement> ... checks) {
        this.delegate = delegate;
        this.checks = checks;
        this.enabled = true;
    }

    @Override
    public void injectFailure(Class<? extends Throwable> ... failureTypes) {
        if (this.enabled && this.calledFromVictimStackTraceElement()) {
            this.delegateFailureInjection(failureTypes);
        }
    }

    @Override
    public boolean injectFailureOrMischief(Class<? extends Throwable> ... failureTypes) {
        return this.enabled && this.calledFromVictimStackTraceElement() && this.delegateFailureOrMischiefInjection(failureTypes);
    }

    protected void delegateFailureInjection(Class<? extends Throwable>[] failureTypes) {
        this.delegate.injectFailure(failureTypes);
    }

    protected boolean delegateFailureOrMischiefInjection(Class<? extends Throwable>[] failureTypes) {
        return this.delegate.injectFailureOrMischief(failureTypes);
    }

    private boolean calledFromVictimStackTraceElement() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            for (Predicate<StackTraceElement> check : this.checks) {
                if (!check.test(element)) continue;
                return true;
            }
        }
        return false;
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }
}

